/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.BooleanStack;
import org.eclipse.collections.api.stack.primitive.ImmutableBooleanStack;
import org.eclipse.collections.api.stack.primitive.MutableBooleanStack;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedBooleanProcedure;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.BooleanStacks;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.stack.primitive.AbstractBooleanStack;

final class ImmutableBooleanArrayStack
extends AbstractBooleanStack
implements ImmutableBooleanStack,
Serializable {
    private static final long serialVersionUID = 1L;
    private final BooleanArrayList delegate;

    private ImmutableBooleanArrayStack(boolean[] newElements) {
        this.checkOptimizedSize(newElements.length);
        this.delegate = new BooleanArrayList(newElements);
    }

    private ImmutableBooleanArrayStack(BooleanArrayList newElements) {
        this.checkOptimizedSize(newElements.size());
        this.delegate = newElements;
    }

    private void checkOptimizedSize(int length) {
        if (length <= 1) {
            throw new IllegalArgumentException("Use BooleanStacks.immutable.with() to instantiate an optimized collection");
        }
    }

    public static ImmutableBooleanArrayStack newStack(BooleanIterable iterable) {
        return new ImmutableBooleanArrayStack(iterable.toArray());
    }

    public static ImmutableBooleanArrayStack newStackWith(boolean ... elements) {
        boolean[] newArray = new boolean[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableBooleanArrayStack(newArray);
    }

    public static ImmutableBooleanArrayStack newStackFromTopToBottom(boolean ... items) {
        return new ImmutableBooleanArrayStack(BooleanArrayList.newListWith(items).reverseThis());
    }

    public static ImmutableBooleanArrayStack newStackFromTopToBottom(BooleanIterable items) {
        return new ImmutableBooleanArrayStack(BooleanArrayList.newList(items).reverseThis());
    }

    @Override
    protected BooleanArrayList getDelegate() {
        return this.delegate;
    }

    public ImmutableBooleanStack push(boolean item) {
        BooleanArrayList newDelegate = BooleanArrayList.newList((BooleanIterable)this.delegate);
        newDelegate.add(item);
        return new ImmutableBooleanArrayStack(newDelegate);
    }

    public ImmutableBooleanStack pop() {
        BooleanArrayList newDelegate = BooleanArrayList.newList((BooleanIterable)this.delegate);
        newDelegate.removeAtIndex(this.delegate.size() - 1);
        return BooleanStacks.immutable.with(newDelegate.toArray());
    }

    public ImmutableBooleanStack pop(int count) {
        this.checkNegativeCount(count);
        if (count == 0) {
            return this;
        }
        this.checkSizeLessThanCount(count);
        BooleanArrayList newDelegate = BooleanArrayList.newList((BooleanIterable)this.delegate);
        while (count > 0) {
            newDelegate.removeAtIndex(newDelegate.size() - 1);
            --count;
        }
        return BooleanStacks.immutable.with(newDelegate.toArray());
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public ImmutableBooleanStack select(BooleanPredicate predicate) {
        return BooleanStacks.immutable.withAllReversed((BooleanIterable)this.delegate.toReversed().select(predicate));
    }

    public ImmutableBooleanStack reject(BooleanPredicate predicate) {
        return BooleanStacks.immutable.withAllReversed((BooleanIterable)this.delegate.toReversed().reject(predicate));
    }

    public <V> ImmutableStack<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Stacks.immutable.withAllReversed((Iterable)this.delegate.asReversed().collect(function));
    }

    public ImmutableBooleanStack toImmutable() {
        return this;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    private Object writeReplace() {
        return new ImmutableBooleanStackSerializationProxy(this);
    }

    public MutableBooleanStack toStack() {
        return BooleanStacks.mutable.withAllReversed((BooleanIterable)this);
    }

    private static class ImmutableBooleanStackSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private BooleanStack stack;

        public ImmutableBooleanStackSerializationProxy() {
        }

        protected ImmutableBooleanStackSerializationProxy(BooleanStack stack) {
            this.stack = stack;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.stack.size());
            try {
                this.stack.forEach((BooleanProcedure)new CheckedBooleanProcedure(){

                    @Override
                    public void safeValue(boolean item) throws IOException {
                        out.writeBoolean(item);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            BooleanArrayList deserializedDelegate = new BooleanArrayList(size);
            for (int i = 0; i < size; ++i) {
                deserializedDelegate.add(in.readBoolean());
            }
            this.stack = ImmutableBooleanArrayStack.newStackFromTopToBottom((BooleanIterable)deserializedDelegate);
        }

        protected Object readResolve() {
            return this.stack;
        }
    }
}

