/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ShortIntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ImmutableIntShortMap;
import org.eclipse.collections.api.map.primitive.ImmutableShortIntMap;
import org.eclipse.collections.api.map.primitive.ShortIntMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.api.tuple.primitive.ShortIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntBags;
import org.eclipse.collections.impl.factory.primitive.IntShortMaps;
import org.eclipse.collections.impl.factory.primitive.ShortIntMaps;
import org.eclipse.collections.impl.factory.primitive.ShortLists;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.ShortIntHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableShortSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableShortIntSingletonMap
implements ImmutableShortIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;
    private final short key1;
    private final int value1;

    ImmutableShortIntSingletonMap(short key1, int value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public int get(short key) {
        return this.getIfAbsent(key, 0);
    }

    public int getIfAbsent(short key, int ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public int getOrThrow(short key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(short key) {
        return this.key1 == key;
    }

    public boolean containsValue(int value) {
        return this.value1 == value;
    }

    public void forEachValue(IntProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(ShortProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(ShortIntProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public boolean allSatisfyKeyValue(ShortIntPredicate predicate) {
        return predicate.accept(this.key1, this.value1);
    }

    public LazyShortIterable keysView() {
        return ShortLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<ShortIntPair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableIntShortMap flipUniqueValues() {
        return IntShortMaps.immutable.with(this.value1, this.key1);
    }

    public ImmutableShortIntMap select(ShortIntPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? ShortIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new ShortIntHashMap().toImmutable();
    }

    public ImmutableShortIntMap reject(ShortIntPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new ShortIntHashMap().toImmutable() : ShortIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public RichIterable<IntIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.mutable.with((Object[])new IntIterable[]{IntBags.immutable.with(this.value1)});
    }

    public ImmutableShortIntMap toImmutable() {
        return this;
    }

    public IntIterator intIterator() {
        return new UnmodifiableIntIterator((IntIterator)ShortIntHashMap.newWithKeysValues(this.key1, this.value1).intIterator());
    }

    public void each(IntProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(IntPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public int min() {
        return this.value1;
    }

    public int max() {
        return this.value1;
    }

    public int maxIfEmpty(int defaultValue) {
        return this.value1;
    }

    public int minIfEmpty(int defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public int[] toSortedArray() {
        return new int[]{this.value1};
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableIntBag select(IntPredicate predicate) {
        return predicate.accept(this.value1) ? IntHashBag.newBagWith(this.value1).toImmutable() : IntBags.immutable.empty();
    }

    public ImmutableIntBag reject(IntPredicate predicate) {
        return predicate.accept(this.value1) ? IntBags.immutable.empty() : IntHashBag.newBagWith(this.value1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        return Bags.immutable.of(function.valueOf(this.value1));
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public int[] toArray() {
        return new int[]{this.value1};
    }

    public int[] toArray(int[] target) {
        if (target.length < 1) {
            target = new int[]{this.value1};
        } else {
            target[0] = this.value1;
        }
        return target;
    }

    public boolean contains(int value) {
        return this.value1 == value;
    }

    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableIntList toList() {
        return IntArrayList.newListWith(this.value1);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSetWith(this.value1);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBagWith(this.value1);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public ImmutableShortIntMap newWithKeyValue(short key, int value) {
        return ShortIntMaps.immutable.withAll((ShortIntMap)ShortIntHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableShortIntMap newWithoutKey(short key) {
        return this.key1 == key ? ShortIntMaps.immutable.with() : this;
    }

    public ImmutableShortIntMap newWithoutAllKeys(ShortIterable keys) {
        return keys.contains(this.key1) ? ShortIntMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableShortSet keySet() {
        return UnmodifiableShortSet.of(ShortHashSet.newSetWith(this.key1));
    }

    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of((MutableIntCollection)IntArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ShortIntMap)) {
            return false;
        }
        ShortIntMap map = (ShortIntMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return this.key1 ^ this.value1;
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

