/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.ui.providers.CreationCommand;

public class CreateInternalFBCommand
extends CreationCommand
implements ScopedCommand {
    private final BaseFBType baseFbType;
    private FBTypeEntry fbTypeEntry;
    private final String name;
    private final int index;
    private FB internalFB;
    static final String DEFAULT_INTERNAL_FB_NAME = "InternalFB1";

    public CreateInternalFBCommand(BaseFBType baseFbType, int index, String name, FBTypeEntry fbTypeEntry) {
        this.baseFbType = Objects.requireNonNull(baseFbType);
        this.fbTypeEntry = fbTypeEntry;
        if (fbTypeEntry == null) {
            this.fbTypeEntry = (FBTypeEntry)baseFbType.getTypeLibrary().getFbTypes().iterator().next();
        }
        this.name = name != null ? name : DEFAULT_INTERNAL_FB_NAME;
        this.index = index;
    }

    public Object getCreatedElement() {
        return this.internalFB;
    }

    private EList<FB> getInteralFBList() {
        return this.baseFbType.getInternalFbs();
    }

    public void execute() {
        this.internalFB = LibraryElementFactory.eINSTANCE.createFB();
        this.internalFB.setTypeEntry((TypeEntry)this.fbTypeEntry);
        this.internalFB.setComment("");
        this.internalFB.setInterface(this.fbTypeEntry.getInterface().copy());
        this.getInteralFBList().add(this.index, (Object)this.internalFB);
        this.internalFB.setName(NameRepository.createUniqueName((INamedElement)this.internalFB, (String)this.name));
    }

    public void undo() {
        this.getInteralFBList().remove((Object)this.internalFB);
    }

    public void redo() {
        this.getInteralFBList().add(this.index, (Object)this.internalFB);
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.baseFbType);
    }
}

