/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.hc.client5.http.entity.compress.ContentCoding;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.io.IOFunction;

@Internal
@Contract(threading=ThreadingBehavior.STATELESS)
final class CommonsCompressCodecFactory {
    private static final String FACTORY_CLASS = "org.apache.commons.compress.compressors.CompressorStreamFactory";
    private static final String CC_BROTLI = "org.apache.commons.compress.compressors.brotli.BrotliCompressorInputStream";
    private static final String CC_ZSTD = "org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream";
    private static final String CC_XZ = "org.apache.commons.compress.compressors.xz.XZCompressorInputStream";
    private static final String CC_LZMA = "org.apache.commons.compress.compressors.lzma.LZMACompressorInputStream";
    private static final String CC_LZ4_F = "org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream";
    private static final String CC_LZ4_B = "org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream";
    private static final String CC_BZIP2 = "org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream";
    private static final String CC_PACK200 = "org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream";
    private static final String CC_DEFLATE64 = "org.apache.commons.compress.compressors.deflate64.Deflate64CompressorInputStream";
    private static final String H_BROTLI = "org.brotli.dec.BrotliInputStream";
    private static final String H_ZSTD = "com.github.luben.zstd.ZstdInputStream";
    private static final String H_XZ = "org.tukaani.xz.XZInputStream";

    private CommonsCompressCodecFactory() {
    }

    private static boolean isPresent(String className) {
        try {
            Class.forName(className, false, CommonsCompressCodecFactory.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException | LinkageError ex) {
            return false;
        }
    }

    static IOFunction<InputStream, InputStream> decoder(String token) {
        String enc = token.toLowerCase(Locale.ROOT);
        CompressorStreamFactory factory = new CompressorStreamFactory();
        return in -> {
            try {
                return factory.createCompressorInputStream(enc, in);
            }
            catch (LinkageError | CompressorException ex) {
                throw new IOException("Unable to decode Content-Encoding '" + enc + '\'', ex);
            }
        };
    }

    static IOFunction<OutputStream, OutputStream> encoder(String token) {
        String enc = token.toLowerCase(Locale.ROOT);
        CompressorStreamFactory factory = new CompressorStreamFactory();
        return in -> {
            try {
                return factory.createCompressorOutputStream(enc, in);
            }
            catch (LinkageError | CompressorException ex) {
                throw new IOException("Unable to decode Content-Encoding '" + enc + '\'', ex);
            }
        };
    }

    static boolean runtimeAvailable(ContentCoding coding) {
        if (coding == null) {
            return false;
        }
        if (!CommonsCompressCodecFactory.isPresent(FACTORY_CLASS)) {
            return false;
        }
        switch (coding) {
            case BROTLI: {
                return CommonsCompressCodecFactory.isPresent(CC_BROTLI) && CommonsCompressCodecFactory.isPresent(H_BROTLI);
            }
            case ZSTD: {
                return CommonsCompressCodecFactory.isPresent(CC_ZSTD) && CommonsCompressCodecFactory.isPresent(H_ZSTD);
            }
            case XZ: {
                return CommonsCompressCodecFactory.isPresent(CC_XZ) && CommonsCompressCodecFactory.isPresent(H_XZ);
            }
            case LZMA: {
                return CommonsCompressCodecFactory.isPresent(CC_LZMA) && CommonsCompressCodecFactory.isPresent(H_XZ);
            }
            case LZ4_FRAMED: {
                return CommonsCompressCodecFactory.isPresent(CC_LZ4_F);
            }
            case LZ4_BLOCK: {
                return CommonsCompressCodecFactory.isPresent(CC_LZ4_B);
            }
            case BZIP2: {
                return CommonsCompressCodecFactory.isPresent(CC_BZIP2);
            }
            case PACK200: {
                return CommonsCompressCodecFactory.isPresent(CC_PACK200) || CommonsCompressCodecFactory.isPresent("java.util.jar.Pack200");
            }
            case DEFLATE64: {
                return CommonsCompressCodecFactory.isPresent(CC_DEFLATE64);
            }
        }
        return false;
    }
}

