/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.common.TEdge;
import org.eclipse.elk.alg.common.TTriangle;
import org.eclipse.elk.alg.common.utils.SVGImage;
import org.eclipse.elk.core.math.KVector;

public final class BowyerWatsonTriangulation {
    private BowyerWatsonTriangulation() {
    }

    public static Set<TEdge> triangulate(List<KVector> vertices, String debugOutputFile) {
        SVGImage svg = new SVGImage(debugOutputFile);
        svg.addGroups("invalid", "tri", "bndry", "done", "new");
        KVector topleft = new KVector(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        KVector bottomright = new KVector(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        for (KVector v : vertices) {
            topleft.x = Math.min(topleft.x, v.x);
            topleft.y = Math.min(topleft.y, v.y);
            bottomright.x = Math.max(bottomright.x, v.x);
            bottomright.y = Math.max(bottomright.y, v.y);
            svg.g("bb").addCircle(v.x, v.y, 18.0, "stroke=\"black\" stroke-width=\"1\" fill=\"lightgray\"");
        }
        KVector size = new KVector(bottomright.x - topleft.x, bottomright.y - topleft.y);
        svg.g("bb").addRect(topleft.x, topleft.y, size.x, size.y, "stroke=\"blue\" stroke-width=\"4\" fill=\"none\"");
        double wiggleroom = 50.0;
        KVector sa = new KVector(topleft.x - 50.0, topleft.y - size.x - 50.0);
        KVector sb = new KVector(topleft.x - 50.0, bottomright.y + size.x + 50.0);
        KVector sc = new KVector(bottomright.x + size.y / 2.0 + 50.0, topleft.y + size.y / 2.0);
        svg.g("bb").addPoly("stroke=\"gray\" stroke-width=\"4\" fill=\"none\" stroke-dasharray=\"20,20\"", sa, sb, sc, sa);
        TTriangle superTriangle = new TTriangle(sa, sb, sc);
        svg.setViewBox(sa.x, sa.y, sc.x - sa.x, sb.y - sa.y);
        svg.isave();
        svg.removeGroup("bb");
        HashSet triangulation = Sets.newHashSet();
        ArrayList invalidTriangles = Lists.newArrayList();
        ArrayList boundary = Lists.newArrayList();
        triangulation.add(superTriangle);
        for (KVector vertex : vertices) {
            svg.g("done").addCircle(vertex.x, vertex.y, 18.0, "stroke=\"black\" stroke-width=\"1\" fill=\"lightgray\"");
            svg.g("new").addCircle(vertex.x, vertex.y, 18.0, "stroke=\"black\" stroke-width=\"1\" fill=\"black\"");
            invalidTriangles.clear();
            for (TTriangle triangle2 : triangulation) {
                svg.g("tri").addPoly("stroke=\"black\" fill=\"none\" stroke-width=\"4\"", triangle2.a, triangle2.b, triangle2.c, triangle2.a);
                KVector c = triangle2.getCircumcenter();
                svg.g("invalid").addCircle(c.x, c.y, c.distance(triangle2.a), "stroke=\"orange\" stroke-width=\"4\" fill=\"none\"");
                if (!triangle2.inCircumcircle(vertex)) continue;
                invalidTriangles.add(triangle2);
                svg.g("invalid").addPoly("stroke=\"none\" fill=\"red\" opacity=\"0.18\"", triangle2.a, triangle2.b, triangle2.c, triangle2.a);
            }
            svg.isave();
            svg.clearGroup("invalid");
            boundary.clear();
            for (TTriangle triangle2 : invalidTriangles) {
                for (TEdge tEdge2 : triangle2.tEdges) {
                    boolean onBoundary = true;
                    for (TTriangle other : invalidTriangles) {
                        if (other == triangle2 || !other.contains(tEdge2)) continue;
                        onBoundary = false;
                    }
                    if (!onBoundary) continue;
                    boundary.add(tEdge2);
                    svg.g("bndry").addLine(tEdge2.u.x, tEdge2.u.y, tEdge2.v.x, tEdge2.v.y, "stroke=\"purple\" stroke-width=\"18\" stroke-dasharray=\"20,20\"");
                }
            }
            svg.isave();
            triangulation.removeAll(invalidTriangles);
            svg.clearGroup("tri");
            triangulation.forEach(triangle -> svg.g("tri").addPoly("stroke=\"black\" fill=\"none\" stroke-width=\"4\"", triangle.a, triangle.b, triangle.c, triangle.a));
            svg.isave();
            for (TEdge tEdge3 : boundary) {
                triangulation.add(new TTriangle(vertex, tEdge3.u, tEdge3.v));
                svg.g("tri").addPoly("stroke=\"black\" fill=\"none\" stroke-width=\"4\"", vertex, tEdge3.u, tEdge3.v, vertex);
            }
            svg.isave();
            svg.clearGroup("new");
            svg.clearGroup("bndry");
            svg.clearGroup("tri");
        }
        HashSet tEdges = Sets.newHashSet();
        triangulation.forEach(triangle -> {
            boolean bl = tEdges.addAll(triangle.tEdges);
        });
        Iterator i = tEdges.iterator();
        while (i.hasNext()) {
            TEdge tEdge3;
            tEdge3 = (TEdge)i.next();
            if (!superTriangle.contains(tEdge3.u) && !superTriangle.contains(tEdge3.v)) continue;
            i.remove();
        }
        tEdges.forEach(tEdge -> svg.addLine(tEdge.u.x, tEdge.u.y, tEdge.v.x, tEdge.v.y, "stroke=\"black\" stroke-width=\"4\""));
        svg.isave();
        return tEdges;
    }

    public static Set<TEdge> triangulate(List<KVector> vertices) {
        return BowyerWatsonTriangulation.triangulate(vertices, null);
    }
}

