/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.rename.RenameElementChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;

public class RenameElementRefactoringParticipant
extends RenameParticipant {
    private URI elementURI;

    protected boolean initialize(Object element) {
        IRenameElementContext context;
        if (element instanceof IRenameElementContext && this.isRelevant(context = (IRenameElementContext)element)) {
            this.elementURI = RenameElementRefactoringParticipant.getCanonicalURI(context.getTargetElementURI());
            return true;
        }
        return false;
    }

    protected boolean isRelevant(IRenameElementContext context) {
        return LibraryElementPackage.Literals.INAMED_ELEMENT.isSuperTypeOf(context.getTargetElementEClass()) && (RenameElementRefactoringParticipant.isTypeURI(context.getTargetElementURI()) || RenameElementRefactoringParticipant.isDataTypeURI(context.getTargetElementURI()) || RenameElementRefactoringParticipant.isAttributeTypeURI(context.getTargetElementURI()));
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        IdentifierVerifier.verifyIdentifier((String)this.getArguments().getNewName()).ifPresent(arg_0 -> ((RefactoringStatus)status).addFatalError(arg_0));
        return status;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(this.getName());
        change.add((Change)new RenameElementChange(this.elementURI.lastSegment(), this.elementURI, this.getArguments().getNewName()));
        return change;
    }

    protected static URI getCanonicalURI(URI uri) {
        if (RenameElementRefactoringParticipant.isTypeURI(uri)) {
            return uri.trimFragment().appendFragment("/" + uri.fragment().substring(2));
        }
        return uri;
    }

    protected static boolean isTypeURI(URI uri) {
        return uri != null && uri.hasFragment() && uri.fragment().startsWith("/1");
    }

    protected static boolean isDataTypeURI(URI uri) {
        return "DTP".equalsIgnoreCase(uri.fileExtension());
    }

    protected static boolean isAttributeTypeURI(URI uri) {
        return "ATP".equalsIgnoreCase(uri.fileExtension());
    }

    public String getName() {
        return Messages.RenameElementRefactoringParticipant_Name;
    }
}

