/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.fordiac.ide.application.commands.ConvertSubappToGroupCommand;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.application.editparts.UISubAppNetworkEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ConvertToGroupHandler
extends AbstractHandler
implements CommandStackEventListener {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        SubApp subApp = ConvertToGroupHandler.getSelectedSubApp(selection);
        if (subApp != null) {
            CommandStack commandStack = HandlerHelper.getCommandStack((IEditorPart)editor);
            ConvertSubappToGroupCommand cmd = new ConvertSubappToGroupCommand(subApp);
            if (cmd.canExecute()) {
                commandStack.execute((Command)cmd);
            }
            commandStack.addCommandStackEventListener((CommandStackEventListener)this);
        }
        return Status.OK_STATUS;
    }

    public void setEnabled(Object evaluationContext) {
        Object selection = HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        SubApp subApp = ConvertToGroupHandler.getSelectedSubApp(selection);
        this.setBaseEnabled(subApp != null && !subApp.isTyped() && !subApp.isContainedInTypedInstance() && !ConvertToGroupHandler.isGroupContainedInSubapp(subApp));
    }

    private static boolean isGroupContainedInSubapp(SubApp subApp) {
        FBNetworkElement group = subApp.getSubAppNetwork().getNetworkElements().stream().filter(Group.class::isInstance).findFirst().orElse(null);
        return group != null;
    }

    private static SubApp getSelectedSubApp(Object selection) {
        IStructuredSelection structSel;
        if (selection instanceof IStructuredSelection && !(structSel = (IStructuredSelection)selection).isEmpty() && structSel.size() == 1) {
            return ConvertToGroupHandler.getSubApp(structSel.getFirstElement());
        }
        return null;
    }

    private static SubApp getSubApp(Object currentElement) {
        if (currentElement instanceof SubApp) {
            return (SubApp)currentElement;
        }
        if (currentElement instanceof SubAppForFBNetworkEditPart) {
            return ((SubAppForFBNetworkEditPart)currentElement).getModel();
        }
        if (currentElement instanceof UISubAppNetworkEditPart) {
            return (SubApp)((UISubAppNetworkEditPart)((Object)currentElement)).getModel().eContainer();
        }
        return null;
    }

    public void stackChanged(CommandStackEvent event) {
    }
}

