/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editparts;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.AbstractInterfaceElementEditPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.TypeField;
import org.eclipse.fordiac.ide.gef.annotation.AnnotableGraphicalEditPart;
import org.eclipse.fordiac.ide.gef.annotation.FordiacAnnotationUtil;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelEvent;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyles;
import org.eclipse.fordiac.ide.gef.editparts.AbstractDirectEditableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ComboCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.ComboDirectEditManager;
import org.eclipse.fordiac.ide.gef.editparts.FigureCellEditorLocator;
import org.eclipse.fordiac.ide.gef.editparts.TypeDeclarationDirectEditManager;
import org.eclipse.fordiac.ide.gef.listeners.DiagramFontChangeListener;
import org.eclipse.fordiac.ide.gef.listeners.IFontUpdateListener;
import org.eclipse.fordiac.ide.gef.policies.ModifiedNonResizeableEditPolicy;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.emf.SingleRecursiveContentAdapter;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.ErrorMarkerDataTypeImpl;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Control;

public class TypeEditPart
extends AbstractInterfaceElementEditPart
implements AnnotableGraphicalEditPart {
    private final TypeLibrary typeLib;
    private DiagramFontChangeListener fontChangeListener;

    public TypeEditPart(TypeLibrary typeLib) {
        this.typeLib = typeLib;
    }

    @Override
    public void activate() {
        super.activate();
        JFaceResources.getFontRegistry().addListener(this.getFontChangeListener());
    }

    @Override
    public void deactivate() {
        super.deactivate();
        JFaceResources.getFontRegistry().removeListener(this.getFontChangeListener());
    }

    @Override
    protected Adapter createAdapter() {
        return new SingleRecursiveContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                TypeEditPart.this.refresh();
            }
        };
    }

    private IPropertyChangeListener getFontChangeListener() {
        if (this.fontChangeListener == null) {
            this.fontChangeListener = new DiagramFontChangeListener((IFontUpdateListener)this.getFigure());
        }
        return this.fontChangeListener;
    }

    @Override
    public IInterfaceElement getCastedModel() {
        return this.getModel().getReferencedElement();
    }

    public TypeField getModel() {
        return (TypeField)super.getModel();
    }

    protected IFigure createFigure() {
        TypeFigure fig = new TypeFigure();
        this.updateFigure(fig);
        return fig;
    }

    public TypeFigure getFigure() {
        return (TypeFigure)super.getFigure();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.updateFigure(this.getFigure());
    }

    private void updateFigure(TypeFigure typeFigure) {
        typeFigure.setText(this.getTypeName());
    }

    public void updateAnnotations(GraphicalAnnotationModelEvent event) {
        GraphicalAnnotationStyles.updateAnnotationFeedback((IFigure)this.getFigure(), (Object)this.getModel().getReferencedElement(), (GraphicalAnnotationModelEvent)event, FordiacAnnotationUtil::showOnTargetType);
    }

    private String getTypeName() {
        return this.getModel().getLabel();
    }

    protected void createEditPolicies() {
        ModifiedNonResizeableEditPolicy handle = new ModifiedNonResizeableEditPolicy();
        handle.setDragAllowed(false);
        this.installEditPolicy("Selection Feedback", (EditPolicy)handle);
        if (this.isDirectEditable()) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy(){

                protected void showCurrentEditValue(DirectEditRequest request) {
                }

                protected Command getDirectEditCommand(DirectEditRequest request) {
                    if (this.getHost() instanceof AbstractDirectEditableEditPart) {
                        Object value = request.getCellEditor().getValue();
                        IInterfaceElement targetElement = TypeEditPart.this.getTargetInterfaceElement();
                        if (value instanceof Integer) {
                            Integer intValue = (Integer)value;
                            int index = intValue;
                            Control control = request.getCellEditor().getControl();
                            if (control instanceof CCombo) {
                                CCombo combo = (CCombo)control;
                                if (index >= 0 && index < combo.getItemCount()) {
                                    String typeName = combo.getItem(index);
                                    return ChangeDataTypeCommand.forTypeName((IInterfaceElement)targetElement, (String)typeName);
                                }
                            }
                        } else if (value instanceof String) {
                            String stringValue = (String)value;
                            return ChangeDataTypeCommand.forTypeDeclaration((IInterfaceElement)targetElement, (String)stringValue);
                        }
                    }
                    return null;
                }
            });
        }
    }

    protected IInterfaceElement getTargetInterfaceElement() {
        VarDeclaration varDecl;
        IInterfaceElement iInterfaceElement = this.getCastedModel();
        if (iInterfaceElement instanceof VarDeclaration && (varDecl = (VarDeclaration)iInterfaceElement).isInOutVar() && !varDecl.isIsInput()) {
            return varDecl.getInOutVarOpposite();
        }
        return this.getCastedModel();
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            request.setType((Object)"direct edit");
        }
        super.performRequest(request);
    }

    protected DirectEditManager createDirectEditManager() {
        IInterfaceElement interfaceElement = this.getCastedModel();
        if (interfaceElement instanceof VarDeclaration) {
            VarDeclaration varDecl = (VarDeclaration)interfaceElement;
            return new TypeDeclarationDirectEditManager((GraphicalEditPart)this, (CellEditorLocator)new FigureCellEditorLocator((IFigure)this.getFigure()), varDecl);
        }
        return new ComboDirectEditManager((GraphicalEditPart)this, ComboBoxCellEditor.class, (CellEditorLocator)new ComboCellEditorLocator((Label)this.getFigure()), (Label)this.getFigure());
    }

    public void performDirectEdit() {
        DirectEditManager editManager = this.createDirectEditManager();
        if (editManager instanceof ComboDirectEditManager) {
            ComboDirectEditManager comboEditManager = (ComboDirectEditManager)editManager;
            List<String> dataTypeNames = this.getCastedModel() instanceof Event ? EventTypeLibrary.getInstance().getEventTypes().stream().map(INamedElement::getName).toList() : (this.getCastedModel() instanceof AdapterDeclaration ? this.typeLib.getAdapterTypesSorted().stream().map(TypeEntry::getTypeName).toList() : this.typeLib.getDataTypeLibrary().getDataTypesSorted().stream().map(INamedElement::getName).toList());
            comboEditManager.updateComboData(dataTypeNames);
            comboEditManager.setSelectedItem(dataTypeNames.indexOf(this.getTypeName()));
        }
        editManager.show();
    }

    public Label getNameLabel() {
        return this.getFigure();
    }

    public INamedElement getINamedElement() {
        return this.getCastedModel();
    }

    @Override
    public boolean isConnectable() {
        return false;
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == ErrorMarkerDataTypeImpl.class) {
            DataType marker = this.getCastedModel().getType();
            return marker instanceof ErrorMarkerDataTypeImpl ? (T)key.cast(marker) : null;
        }
        return (T)super.getAdapter(key);
    }

    private static class TypeFigure
    extends Label
    implements IFontUpdateListener {
        public TypeFigure() {
            this.setTypeLabelFonts();
        }

        public void updateFonts() {
            this.setTypeLabelFonts();
            this.invalidateTree();
            this.revalidate();
        }

        private void setTypeLabelFonts() {
            this.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
        }
    }
}

