/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.Scanner;
import java.util.regex.Pattern;

public interface ValueConverter<T> {
    public static final Pattern ANY_PATTERN = Pattern.compile(".*", 32);

    default public String toString(T value) {
        return Objects.toString(value).toUpperCase();
    }

    public T toValue(String var1) throws IllegalArgumentException;

    public T toValue(Scanner var1) throws IllegalArgumentException;

    default public T toValue(Scanner scanner, Pattern pattern) throws IllegalArgumentException {
        String string = scanner.findWithinHorizon(pattern, 0);
        if (string == null) {
            throw new IllegalArgumentException(MessageFormat.format("Invalid value: {0}", scanner.findWithinHorizon(ANY_PATTERN, 0)));
        }
        return this.toValue(string);
    }
}

