/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.topdownpacking;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.elk.alg.topdownpacking.GridElkNode;
import org.eclipse.elk.alg.topdownpacking.INodeArranger;
import org.eclipse.elk.alg.topdownpacking.TopdownPackingPhases;
import org.eclipse.elk.alg.topdownpacking.options.TopdownpackingOptions;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class LeftRightTopDownNodePlacer
implements ILayoutPhase<TopdownPackingPhases, GridElkNode>,
INodeArranger {
    public void process(GridElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Node placement", 1.0f);
        progressMonitor.log((Object)("Node placement began for node " + layoutGraph.getIdentifier()));
        ElkPadding padding = layoutGraph.getProperty(TopdownpackingOptions.PADDING);
        double nodeNodeSpacing = layoutGraph.getProperty(TopdownpackingOptions.SPACING_NODE_NODE);
        KVector graphSize = this.getPredictedSize(layoutGraph);
        layoutGraph.setDimensions(Math.max(layoutGraph.getWidth(), graphSize.x), Math.max(layoutGraph.getHeight(), graphSize.y));
        ArrayList<ElkNode> nodes = new ArrayList<ElkNode>((Collection<ElkNode>)layoutGraph.getChildren());
        int cols = (int)Math.ceil(Math.sqrt(nodes.size()));
        int rows = nodes.size() > cols * cols - cols || cols == 0 ? cols : cols - 1;
        layoutGraph.setGridSize(cols, rows);
        progressMonitor.log((Object)(layoutGraph.getIdentifier() + "\nPlacing " + nodes.size() + " nodes in " + cols + " columns."));
        progressMonitor.done();
        progressMonitor.log((Object)"Node Arrangement done!");
        double currX = padding.left;
        double currY = padding.top;
        int currentCol = 0;
        int currentRow = 0;
        double desiredNodeWidth = (Double)layoutGraph.getProperty(CoreOptions.TOPDOWN_HIERARCHICAL_NODE_WIDTH);
        double aspectRatio = (Double)layoutGraph.getProperty(CoreOptions.TOPDOWN_HIERARCHICAL_NODE_ASPECT_RATIO);
        for (ElkNode node : nodes) {
            node.setDimensions(desiredNodeWidth, desiredNodeWidth / aspectRatio);
            node.setX(currX);
            node.setY(currY);
            progressMonitor.log((Object)("currX: " + currX));
            progressMonitor.log((Object)("currY: " + currY));
            layoutGraph.put(currentCol, currentRow, node);
            progressMonitor.logGraph((ElkNode)layoutGraph, node.getIdentifier() + " placed in (" + currentCol + "|" + currentRow + ")");
            currX += node.getWidth() + nodeNodeSpacing;
            if (++currentCol < cols) continue;
            currX = padding.left;
            currY += desiredNodeWidth / aspectRatio + nodeNodeSpacing;
            currentCol = 0;
            ++currentRow;
        }
        progressMonitor.log((Object)"Node Placing done!");
        progressMonitor.logGraph((ElkNode)layoutGraph, "Graph after node placement");
        progressMonitor.done();
    }

    public LayoutProcessorConfiguration<TopdownPackingPhases, GridElkNode> getLayoutProcessorConfiguration(GridElkNode graph) {
        return LayoutProcessorConfiguration.create();
    }

    @Override
    public KVector getPredictedSize(ElkNode graph) {
        int numberOfChildren = graph.getChildren().size();
        ElkPadding padding = (ElkPadding)graph.getProperty(TopdownpackingOptions.PADDING);
        double nodeNodeSpacing = (Double)graph.getProperty(TopdownpackingOptions.SPACING_NODE_NODE);
        double hierarchicalNodeWidth = (Double)graph.getProperty(CoreOptions.TOPDOWN_HIERARCHICAL_NODE_WIDTH);
        double hierarchicalNodeAspectRatio = (Double)graph.getProperty(CoreOptions.TOPDOWN_HIERARCHICAL_NODE_ASPECT_RATIO);
        int cols = (int)Math.ceil(Math.sqrt(numberOfChildren));
        double requiredWidth = (double)cols * hierarchicalNodeWidth + padding.left + padding.right + (double)(cols - 1) * nodeNodeSpacing;
        int rows = numberOfChildren > cols * cols - cols || cols == 0 ? cols : cols - 1;
        double requiredHeight = (double)rows * hierarchicalNodeWidth / hierarchicalNodeAspectRatio + padding.top + padding.bottom + (double)(rows - 1) * nodeNodeSpacing;
        return new KVector(requiredWidth, requiredHeight);
    }
}

