/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.netty.fsm;

import io.netty.channel.Channel;
import java.util.concurrent.CompletableFuture;

public interface Event {

    public static class ReconnectDelayElapsed
    implements Event {
        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class KeepAliveFailure
    implements Event {
        final Throwable failure;

        KeepAliveFailure(Throwable failure) {
            this.failure = failure;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class GetChannel
    implements Event {
        final CompletableFuture<Channel> channelFuture = new CompletableFuture();
        final boolean waitForReconnect;

        GetChannel() {
            this(true);
        }

        GetChannel(boolean waitForReconnect) {
            this.waitForReconnect = waitForReconnect;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class DisconnectSuccess
    implements Event {
        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class Disconnect
    implements Event {
        final CompletableFuture<Void> disconnectFuture = new CompletableFuture();

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class ConnectFailure
    implements Event {
        final Throwable failure;

        public ConnectFailure(Throwable failure) {
            this.failure = failure;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class ConnectSuccess
    implements Event {
        final Channel channel;

        public ConnectSuccess(Channel channel) {
            this.channel = channel;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class Connect
    implements Event {
        final CompletableFuture<Channel> channelFuture = new CompletableFuture();

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class ChannelInactive
    implements Event {
        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public static class ChannelIdle
    implements Event {
        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

