/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.List;
import java.util.function.Supplier;
import org.eclipse.fordiac.ide.gef.annotation.FordiacAnnotationUtil;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.nat.AbstractAnnotatedConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.AttributeTableColumn;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.edit.helper.CommentHelper;
import org.eclipse.fordiac.ide.model.edit.helper.InitialValueHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;

public class AttributeConfigLabelAccumulator
extends AbstractAnnotatedConfigLabelAccumulator<Attribute> {
    private final List<AttributeTableColumn> columns;

    public AttributeConfigLabelAccumulator(IRowDataProvider<Attribute> dataProvider) {
        this(dataProvider, () -> null);
    }

    public AttributeConfigLabelAccumulator(IRowDataProvider<Attribute> dataProvider, Supplier<GraphicalAnnotationModel> annotationModelSupplier) {
        this(dataProvider, annotationModelSupplier, AttributeTableColumn.DEFAULT_COLUMNS);
    }

    public AttributeConfigLabelAccumulator(IRowDataProvider<Attribute> dataProvider, Supplier<GraphicalAnnotationModel> annotationModelSupplier, List<AttributeTableColumn> columns) {
        super(dataProvider, annotationModelSupplier);
        this.columns = columns;
    }

    public List<AttributeTableColumn> getColumns() {
        return this.columns;
    }

    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        Attribute rowItem = (Attribute)this.getDataProvider().getRowObject(rowPosition);
        switch (this.columns.get(columnPosition)) {
            case NAME: {
                configLabels.addLabel("ATTRIBUTE_PROPOSAL_CELL");
                configLabels.addLabelOnTop("LEFT_ALIGNMENT");
                this.accumulateAttributeConfigLabels(configLabels, rowItem, FordiacAnnotationUtil::showOnTargetName);
                break;
            }
            case TYPE: {
                configLabels.addLabel("PROPOSAL_CELL");
                this.accumulateAttributeConfigLabels(configLabels, rowItem, FordiacAnnotationUtil::showOnTargetType);
                break;
            }
            case VALUE: {
                if (rowItem.getType() instanceof StructuredType) {
                    configLabels.addLabel("INITIAL_VALUE_STRUCTURED_CELL");
                } else {
                    configLabels.addLabel("INITIAL_VALUE_CELL");
                }
                if (!InitialValueHelper.hasInitalValue((Object)rowItem)) {
                    configLabels.addLabelOnTop("DEFAULT_CELL");
                }
                this.accumulateAttributeConfigLabels(configLabels, rowItem, FordiacAnnotationUtil::showOnTargetValue);
                break;
            }
            case COMMENT: {
                configLabels.addLabelOnTop("LEFT_ALIGNMENT");
                if (CommentHelper.hasComment((INamedElement)rowItem)) break;
                configLabels.addLabelOnTop("DEFAULT_CELL");
                break;
            }
            case FILE_PATH: {
                configLabels.addLabelOnTop("LEFT_TRUNCATING");
                break;
            }
            case LOCATION: {
                configLabels.addLabelOnTop("LEFT_ALIGNMENT");
                break;
            }
        }
    }
}

