package Locales::DB::Territory::pt_pt;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::pt_pt::VERSION = '0.09';

$Locales::DB::Territory::pt_pt::cldr_version = '2.0';

%Locales::DB::Territory::pt_pt::code_to_name = (
    '001' => 'Mundo',
    '002' => 'África',
    '003' => "América\ do\ Norte",
    '005' => "América\ do\ Sul",
    '009' => 'Oceânia',
    '011' => "África\ Ocidental",
    '013' => "América\ Central",
    '014' => "África\ Oriental",
    '015' => "Norte\ de\ África",
    '017' => "África\ Central",
    '018' => "África\ Austral",
    '019' => 'Américas',
    '021' => "América\ Setentrional",
    '029' => 'Caribe',
    '030' => "Ásia\ Oriental",
    '034' => "Ásia\ do\ Sul",
    '035' => "Sudeste\ Asiático",
    '039' => "Europa\ do\ Sul",
    '053' => "Austrália\ e\ Nova\ Zelândia",
    '054' => 'Melanésia',
    '057' => "Região\ da\ Micronésia",
    '061' => 'Polinésia',
    '062' => "Ásia\ Centro\-Meridional",
    142   => 'Ásia',
    143   => "Ásia\ Central",
    145   => "Ásia\ Ocidental",
    150   => 'Europa',
    151   => "Europa\ Oriental",
    154   => "Europa\ do\ Norte",
    155   => "Europa\ Ocidental",
    172   => "Comunidade\ dos\ Estados\ Independentes",
    200   => 'Czechoslovakia',
    419   => "América\ Latina\ e\ Caribe",
    830   => "Channel\ Islands",
    'ac'  => 'Ascensão',
    'ad'  => 'Andorra',
    'ae'  => "Emiratos\ Árabes\ Unidos",
    'af'  => 'Afeganistão',
    'ag'  => "Antígua\ e\ Barbuda",
    'ai'  => 'Anguila',
    'al'  => 'Albânia',
    'am'  => 'Arménia',
    'an'  => "Antilhas\ Holandesas",
    'ao'  => 'Angola',
    'aq'  => 'Antárctica',
    'ar'  => 'Argentina',
    'as'  => "Samoa\ Americana",
    'at'  => 'Áustria',
    'au'  => 'Austrália',
    'aw'  => 'Aruba',
    'ax'  => "Ilhas\ Åland",
    'az'  => 'Azerbeijão',
    'ba'  => "Bósnia\-Herzegovina",
    'bb'  => 'Barbados',
    'bd'  => 'Bangladeche',
    'be'  => 'Bélgica',
    'bf'  => "Burkina\-Faso",
    'bg'  => 'Bulgária',
    'bh'  => 'Bahrein',
    'bi'  => 'Burundi',
    'bj'  => 'Benim',
    'bl'  => "São\ Bartolomeu",
    'bm'  => 'Bermudas',
    'bn'  => 'Brunei',
    'bo'  => 'Bolívia',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Brasil',
    'bs'  => 'Baamas',
    'bt'  => 'Butão',
    'bv'  => "Ilha\ Bouvet",
    'bw'  => 'Botsuana',
    'by'  => 'Bielorrússia',
    'bz'  => 'Belize',
    'ca'  => 'Canadá',
    'cc'  => "Ilhas\ Cocos",
    'cd'  => "República\ Democrática\ do\ Congo",
    'cf'  => "República\ Centro\-Africana",
    'cg'  => "República\ do\ Congo",
    'ch'  => 'Suíça',
    'ci'  => "Costa\ do\ Marfim",
    'ck'  => "Ilhas\ Cook",
    'cl'  => 'Chile',
    'cm'  => 'Camarões',
    'cn'  => 'China',
    'co'  => 'Colômbia',
    'cp'  => "Ilha\ de\ Clipperton",
    'cr'  => "Costa\ Rica",
    'cs'  => "Sérvia\ e\ Montenegro",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Cuba',
    'cv'  => "Cabo\ Verde",
    'cx'  => "Ilha\ do\ Natal",
    'cy'  => 'Chipre',
    'cz'  => "República\ Checa",
    'dd'  => "East\ Germany",
    'de'  => 'Alemanha',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Jibuti',
    'dk'  => 'Dinamarca',
    'dm'  => 'Dominica',
    'do'  => "República\ Dominicana",
    'dz'  => 'Argélia',
    'ea'  => "Ceuta\ e\ Melilha",
    'ec'  => 'Equador',
    'ee'  => 'Estónia',
    'eg'  => 'Egipto',
    'eh'  => "Sara\ Ocidental",
    'er'  => 'Eritreia',
    'es'  => 'Espanha',
    'et'  => 'Etiópia',
    'eu'  => "União\ Europeia",
    'fi'  => 'Finlândia',
    'fj'  => 'Fiji',
    'fk'  => "Ilhas\ Falkland",
    'fm'  => "Estados\ Federados\ da\ Micronésia",
    'fo'  => "Ilhas\ Faroé",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'França',
    'fx'  => "França\ \(continental\)",
    'ga'  => 'Gabão',
    'gb'  => "Reino\ Unido",
    'gd'  => 'Granada',
    'ge'  => 'Geórgia',
    'gf'  => "Guiana\ Francesa",
    'gg'  => 'Guernsey',
    'gh'  => 'Gana',
    'gi'  => 'Gibraltar',
    'gl'  => 'Gronelândia',
    'gm'  => 'Gâmbia',
    'gn'  => 'Guiné',
    'gp'  => 'Guadalupe',
    'gq'  => "Guiné\ Equatorial",
    'gr'  => 'Grécia',
    'gs'  => "Geórgia\ do\ Sul\ e\ Ilhas\ Sandwich\ do\ Sul",
    'gt'  => 'Guatemala',
    'gu'  => 'Guam',
    'gw'  => "Guiné\-Bissau",
    'gy'  => 'Guiana',
    'hk'  => "Região\ Administrativa\ Especial\ de\ Hong\ Kong",
    'hm'  => "Ilha\ Heard\ e\ Ilhas\ McDonald",
    'hn'  => 'Honduras',
    'hr'  => 'Croácia',
    'ht'  => 'Haiti',
    'hu'  => 'Hungria',
    'ic'  => "Ilhas\ Canárias",
    'id'  => 'Indonésia',
    'ie'  => 'Irlanda',
    'il'  => 'Israel',
    'im'  => "Ilha\ de\ Man",
    'in'  => 'Índia',
    'io'  => "Território\ Britânico\ do\ Oceano\ Índico",
    'iq'  => 'Iraque',
    'ir'  => 'Irão',
    'is'  => 'Islândia',
    'it'  => 'Itália',
    'je'  => 'Jersey',
    'jm'  => 'Jamaica',
    'jo'  => 'Jordânia',
    'jp'  => 'Japão',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Quénia',
    'kg'  => 'Quirguizistão',
    'kh'  => 'Camboja',
    'ki'  => 'Quiribati',
    'km'  => 'Comores',
    'kn'  => "Saint\ Kitts\ e\ Nevis",
    'kp'  => "Coreia\ do\ Norte",
    'kr'  => "Coreia\ do\ Sul",
    'kw'  => 'Koweit',
    'ky'  => "Ilhas\ Caimão",
    'kz'  => 'Cazaquistão',
    'la'  => "Laos\,\ República\ Popular\ Democrática\ do",
    'lb'  => 'Líbano',
    'lc'  => "Santa\ Lúcia",
    'li'  => 'Liechtenstein',
    'lk'  => "Sri\ Lanca",
    'lr'  => 'Libéria',
    'ls'  => 'Lesoto',
    'lt'  => 'Lituânia',
    'lu'  => 'Luxemburgo',
    'lv'  => 'Letónia',
    'ly'  => 'Líbia',
    'ma'  => 'Marrocos',
    'mc'  => 'Mónaco',
    'md'  => "Moldávia\,\ República\ da",
    'me'  => 'Montenegro',
    'mf'  => "São\ Martinho",
    'mg'  => 'Madagáscar',
    'mh'  => "Ilhas\ Marshall",
    'mi'  => "Midway\ Islands",
    'mk'  => "Antiga\ República\ jugoslava\ da\ Macedónia",
    'ml'  => 'Mali',
    'mm'  => 'Mianmar',
    'mn'  => 'Mongólia',
    'mo'  => "Região\ Administrativa\ Especial\ de\ Macau",
    'mp'  => "Ilhas\ Mariana\ do\ Norte",
    'mq'  => 'Martinica',
    'mr'  => 'Mauritânia',
    'ms'  => 'Monserrate',
    'mt'  => 'Malta',
    'mu'  => 'Maurícias',
    'mv'  => 'Maldivas',
    'mw'  => 'Malavi',
    'mx'  => 'México',
    'my'  => 'Malásia',
    'mz'  => 'Moçambique',
    'na'  => 'Namíbia',
    'nc'  => "Nova\ Caledónia",
    'ne'  => 'Níger',
    'nf'  => "Ilha\ Norfolk",
    'ng'  => 'Nigéria',
    'ni'  => 'Nicarágua',
    'nl'  => "Países\ Baixos",
    'no'  => 'Noruega',
    'np'  => 'Nepal',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Nauru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niue',
    'nz'  => "Nova\ Zelândia",
    'om'  => 'Omã',
    'pa'  => 'Panamá',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Peru',
    'pf'  => "Polinésia\ Francesa",
    'pg'  => "Papuásia\-Nova\ Guiné",
    'ph'  => 'Filipinas',
    'pk'  => 'Paquistão',
    'pl'  => 'Polónia',
    'pm'  => "Saint\ Pierre\ e\ Miquelon",
    'pn'  => 'Pitcairn',
    'pr'  => "Porto\ Rico",
    'ps'  => "Território\ Palestiniano",
    'pt'  => 'Portugal',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'Paraguai',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Catar',
    'qo'  => "Oceânia\ Insular",
    're'  => 'Reunião',
    'ro'  => 'Roménia',
    'rs'  => 'Sérvia',
    'ru'  => 'Rússia',
    'rw'  => 'Ruanda',
    'sa'  => "Arábia\ Saudita",
    'sb'  => "Ilhas\ Salomão",
    'sc'  => 'Seicheles',
    'sd'  => 'Sudão',
    'se'  => 'Suécia',
    'sg'  => 'Singapura',
    'sh'  => "Santa\ Helena",
    'si'  => 'Eslovénia',
    'sj'  => "Svalbard\ e\ Jan\ Mayen",
    'sk'  => 'Eslováquia',
    'sl'  => "Serra\ Leoa",
    'sm'  => "São\ Marino",
    'sn'  => 'Senegal',
    'so'  => 'Somália',
    'sr'  => 'Suriname',
    'st'  => "São\ Tomé\ e\ Príncipe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "El\ Salvador",
    'sy'  => 'Síria',
    'sz'  => 'Suazilândia',
    'ta'  => "Tristão\ da\ Cunha",
    'tc'  => "Ilhas\ Turcas\ e\ Caicos",
    'td'  => 'Chade',
    'tf'  => "Territórios\ Franceses\ do\ Sul",
    'tg'  => 'Togo',
    'th'  => 'Tailândia',
    'tj'  => 'Tajiquistão',
    'tk'  => 'Tokelau',
    'tl'  => "Timor\-Leste",
    'tm'  => 'Turquemenistão',
    'tn'  => 'Tunísia',
    'to'  => 'Tonga',
    'tr'  => 'Turquia',
    'tt'  => "Trindade\ e\ Tobago",
    'tv'  => 'Tuvalu',
    'tw'  => 'Taiwan',
    'tz'  => 'Tanzânia',
    'ua'  => 'Ucrânia',
    'ug'  => 'Uganda',
    'um'  => "Ilhas\ Menores\ Distantes\ dos\ Estados\ Unidos",
    'us'  => "Estados\ Unidos",
    'uy'  => 'Uruguai',
    'uz'  => 'Usbequistão',
    'va'  => 'Vaticano',
    'vc'  => "São\ Vicente\ e\ Granadinas",
    'vd'  => "North\ Vietnam",
    've'  => 'Venezuela',
    'vg'  => "Ilhas\ Virgens\ Britânicas",
    'vi'  => "Ilhas\ Virgin\ E\.U\.A\.",
    'vn'  => 'Vietname',
    'vu'  => 'Vanuatu',
    'wf'  => "Wallis\ e\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Iémen',
    'yt'  => 'Mayotte',
    'za'  => "África\ do\ Sul",
    'zm'  => 'Zâmbia',
    'zw'  => 'Zimbabwe',
    'zz'  => "Região\ desconhecida\ ou\ inválida",
);

%Locales::DB::Territory::pt_pt::name_to_code = (
    'afeganistão'                              => 'af',
    'albânia'                                  => 'al',
    'alemanha'                                  => 'de',
    'américacentral'                           => '013',
    'américadonorte'                           => '003',
    'américadosul'                             => '005',
    'américalatinaecaribe'                     => 419,
    'américas'                                 => '019',
    'américasetentrional'                      => '021',
    'andorra'                                   => 'ad',
    'angola'                                    => 'ao',
    'anguila'                                   => 'ai',
    'antigarepúblicajugoslavadamacedónia'     => 'mk',
    'antilhasholandesas'                        => 'an',
    'antárctica'                               => 'aq',
    'antíguaebarbuda'                          => 'ag',
    'argentina'                                 => 'ar',
    'argélia'                                  => 'dz',
    'arménia'                                  => 'am',
    'aruba'                                     => 'aw',
    'arábiasaudita'                            => 'sa',
    'ascensão'                                 => 'ac',
    'austrália'                                => 'au',
    'austráliaenovazelândia'                  => '053',
    'azerbeijão'                               => 'az',
    'baamas'                                    => 'bs',
    'bahrein'                                   => 'bh',
    'bangladeche'                               => 'bd',
    'barbados'                                  => 'bb',
    'belize'                                    => 'bz',
    'benim'                                     => 'bj',
    'bermudas'                                  => 'bm',
    'bielorrússia'                             => 'by',
    'bolívia'                                  => 'bo',
    'botsuana'                                  => 'bw',
    'brasil'                                    => 'br',
    'britishantarcticterritory'                 => 'bq',
    'brunei'                                    => 'bn',
    'bulgária'                                 => 'bg',
    'burkinafaso'                               => 'bf',
    'burundi'                                   => 'bi',
    'butão'                                    => 'bt',
    'bélgica'                                  => 'be',
    'bósniaherzegovina'                        => 'ba',
    'caboverde'                                 => 'cv',
    'camarões'                                 => 'cm',
    'camboja'                                   => 'kh',
    'canadá'                                   => 'ca',
    'cantonandenderburyislands'                 => 'ct',
    'caribe'                                    => '029',
    'catar'                                     => 'qa',
    'cazaquistão'                              => 'kz',
    'ceutaemelilha'                             => 'ea',
    'chade'                                     => 'td',
    'channelislands'                            => 830,
    'chile'                                     => 'cl',
    'china'                                     => 'cn',
    'chipre'                                    => 'cy',
    'colômbia'                                 => 'co',
    'comores'                                   => 'km',
    'comunidadedosestadosindependentes'         => 172,
    'coreiadonorte'                             => 'kp',
    'coreiadosul'                               => 'kr',
    'costadomarfim'                             => 'ci',
    'costarica'                                 => 'cr',
    'croácia'                                  => 'hr',
    'cuba'                                      => 'cu',
    'czechoslovakia'                            => 200,
    'diegogarcia'                               => 'dg',
    'dinamarca'                                 => 'dk',
    'dominica'                                  => 'dm',
    'dronningmaudland'                          => 'nq',
    'eastgermany'                               => 'dd',
    'egipto'                                    => 'eg',
    'elsalvador'                                => 'sv',
    'emiratosÁrabesunidos'                     => 'ae',
    'equador'                                   => 'ec',
    'eritreia'                                  => 'er',
    'eslováquia'                               => 'sk',
    'eslovénia'                                => 'si',
    'espanha'                                   => 'es',
    'estadosfederadosdamicronésia'             => 'fm',
    'estadosunidos'                             => 'us',
    'estónia'                                  => 'ee',
    'etiópia'                                  => 'et',
    'europa'                                    => 150,
    'europadonorte'                             => 154,
    'europadosul'                               => '039',
    'europaocidental'                           => 155,
    'europaoriental'                            => 151,
    'fiji'                                      => 'fj',
    'filipinas'                                 => 'ph',
    'finlândia'                                => 'fi',
    'frança'                                   => 'fr',
    'françacontinental'                        => 'fx',
    'frenchsouthernandantarcticterritories'     => 'fq',
    'gabão'                                    => 'ga',
    'gana'                                      => 'gh',
    'geórgia'                                  => 'ge',
    'geórgiadosuleilhassandwichdosul'          => 'gs',
    'gibraltar'                                 => 'gi',
    'granada'                                   => 'gd',
    'gronelândia'                              => 'gl',
    'grécia'                                   => 'gr',
    'guadalupe'                                 => 'gp',
    'guam'                                      => 'gu',
    'guatemala'                                 => 'gt',
    'guernsey'                                  => 'gg',
    'guiana'                                    => 'gy',
    'guianafrancesa'                            => 'gf',
    'guiné'                                    => 'gn',
    'guinébissau'                              => 'gw',
    'guinéequatorial'                          => 'gq',
    'gâmbia'                                   => 'gm',
    'haiti'                                     => 'ht',
    'honduras'                                  => 'hn',
    'hungria'                                   => 'hu',
    'ilhabouvet'                                => 'bv',
    'ilhadeclipperton'                          => 'cp',
    'ilhademan'                                 => 'im',
    'ilhadonatal'                               => 'cx',
    'ilhaheardeilhasmcdonald'                   => 'hm',
    'ilhanorfolk'                               => 'nf',
    'ilhascaimão'                              => 'ky',
    'ilhascanárias'                            => 'ic',
    'ilhascocos'                                => 'cc',
    'ilhascook'                                 => 'ck',
    'ilhasfalkland'                             => 'fk',
    'ilhasfaroé'                               => 'fo',
    'ilhasmarianadonorte'                       => 'mp',
    'ilhasmarshall'                             => 'mh',
    'ilhasmenoresdistantesdosestadosunidos'     => 'um',
    'ilhassalomão'                             => 'sb',
    'ilhasturcasecaicos'                        => 'tc',
    'ilhasvirgensbritânicas'                   => 'vg',
    "ilhasvirgine\.u\.a\."                      => 'vi',
    'ilhasÅland'                               => 'ax',
    'indonésia'                                => 'id',
    'iraque'                                    => 'iq',
    'irlanda'                                   => 'ie',
    'irão'                                     => 'ir',
    'islândia'                                 => 'is',
    'israel'                                    => 'il',
    'itália'                                   => 'it',
    'iémen'                                    => 'ye',
    'jamaica'                                   => 'jm',
    'japão'                                    => 'jp',
    'jersey'                                    => 'je',
    'jibuti'                                    => 'dj',
    'johnstonisland'                            => 'jt',
    'jordânia'                                 => 'jo',
    'koweit'                                    => 'kw',
    "laos\,repúblicapopulardemocráticado"     => 'la',
    'lesoto'                                    => 'ls',
    'letónia'                                  => 'lv',
    'libéria'                                  => 'lr',
    'liechtenstein'                             => 'li',
    'lituânia'                                 => 'lt',
    'luxemburgo'                                => 'lu',
    'líbano'                                   => 'lb',
    'líbia'                                    => 'ly',
    'madagáscar'                               => 'mg',
    'malavi'                                    => 'mw',
    'maldivas'                                  => 'mv',
    'mali'                                      => 'ml',
    'malta'                                     => 'mt',
    'malásia'                                  => 'my',
    'marrocos'                                  => 'ma',
    'martinica'                                 => 'mq',
    'mauritânia'                               => 'mr',
    'maurícias'                                => 'mu',
    'mayotte'                                   => 'yt',
    'melanésia'                                => '054',
    'mianmar'                                   => 'mm',
    'midwayislands'                             => 'mi',
    "moldávia\,repúblicada"                   => 'md',
    'mongólia'                                 => 'mn',
    'monserrate'                                => 'ms',
    'montenegro'                                => 'me',
    'moçambique'                               => 'mz',
    'mundo'                                     => '001',
    'méxico'                                   => 'mx',
    'mónaco'                                   => 'mc',
    'namíbia'                                  => 'na',
    'nauru'                                     => 'nr',
    'nepal'                                     => 'np',
    'neutralzone'                               => 'nt',
    'nicarágua'                                => 'ni',
    'nigéria'                                  => 'ng',
    'niue'                                      => 'nu',
    'nortedeÁfrica'                            => '015',
    'northvietnam'                              => 'vd',
    'noruega'                                   => 'no',
    'novacaledónia'                            => 'nc',
    'novazelândia'                             => 'nz',
    'níger'                                    => 'ne',
    'oceânia'                                  => '009',
    'oceâniainsular'                           => 'qo',
    'omã'                                      => 'om',
    'pacificislandstrustterritory'              => 'pc',
    'palau'                                     => 'pw',
    'panamacanalzone'                           => 'pz',
    'panamá'                                   => 'pa',
    'papuásianovaguiné'                       => 'pg',
    'paquistão'                                => 'pk',
    'paraguai'                                  => 'py',
    'paísesbaixos'                             => 'nl',
    "people\â\\sdemocraticrepublicofyemen" => 'yd',
    'peru'                                      => 'pe',
    'pitcairn'                                  => 'pn',
    'polinésia'                                => '061',
    'polinésiafrancesa'                        => 'pf',
    'polónia'                                  => 'pl',
    'portorico'                                 => 'pr',
    'portugal'                                  => 'pt',
    'quirguizistão'                            => 'kg',
    'quiribati'                                 => 'ki',
    'quénia'                                   => 'ke',
    'regiãoadministrativaespecialdehongkong'   => 'hk',
    'regiãoadministrativaespecialdemacau'      => 'mo',
    'regiãodamicronésia'                      => '057',
    'regiãodesconhecidaouinválida'            => 'zz',
    'reinounido'                                => 'gb',
    'repúblicacentroafricana'                  => 'cf',
    'repúblicacheca'                           => 'cz',
    'repúblicademocráticadocongo'             => 'cd',
    'repúblicadocongo'                         => 'cg',
    'repúblicadominicana'                      => 'do',
    'reunião'                                  => 're',
    'roménia'                                  => 'ro',
    'ruanda'                                    => 'rw',
    'rússia'                                   => 'ru',
    'saintkittsenevis'                          => 'kn',
    'saintpierreemiquelon'                      => 'pm',
    'samoa'                                     => 'ws',
    'samoaamericana'                            => 'as',
    'santahelena'                               => 'sh',
    'santalúcia'                               => 'lc',
    'saraocidental'                             => 'eh',
    'seicheles'                                 => 'sc',
    'senegal'                                   => 'sn',
    'serraleoa'                                 => 'sl',
    'singapura'                                 => 'sg',
    'somália'                                  => 'so',
    'srilanca'                                  => 'lk',
    'suazilândia'                              => 'sz',
    'sudesteasiático'                          => '035',
    'sudão'                                    => 'sd',
    'suriname'                                  => 'sr',
    'suécia'                                   => 'se',
    'suíça'                                   => 'ch',
    'svalbardejanmayen'                         => 'sj',
    'sãobartolomeu'                            => 'bl',
    'sãomarino'                                => 'sm',
    'sãomartinho'                              => 'mf',
    'sãotoméepríncipe'                       => 'st',
    'sãovicenteegranadinas'                    => 'vc',
    'sérvia'                                   => 'rs',
    'sérviaemontenegro'                        => 'cs',
    'síria'                                    => 'sy',
    'tailândia'                                => 'th',
    'taiwan'                                    => 'tw',
    'tajiquistão'                              => 'tj',
    'tanzânia'                                 => 'tz',
    'territóriobritânicodooceanoÍndico'      => 'io',
    'territóriopalestiniano'                   => 'ps',
    'territóriosfrancesesdosul'                => 'tf',
    'timorleste'                                => 'tl',
    'togo'                                      => 'tg',
    'tokelau'                                   => 'tk',
    'tonga'                                     => 'to',
    'trindadeetobago'                           => 'tt',
    'tristãodacunha'                           => 'ta',
    'tunísia'                                  => 'tn',
    'turquemenistão'                           => 'tm',
    'turquia'                                   => 'tr',
    'tuvalu'                                    => 'tv',
    "u\.s\.miscellaneouspacificislands"         => 'pu',
    'ucrânia'                                  => 'ua',
    'uganda'                                    => 'ug',
    'unionofsovietsocialistrepublics'           => 'su',
    'uniãoeuropeia'                            => 'eu',
    'uruguai'                                   => 'uy',
    'usbequistão'                              => 'uz',
    'vanuatu'                                   => 'vu',
    'vaticano'                                  => 'va',
    'venezuela'                                 => 've',
    'vietname'                                  => 'vn',
    'wakeisland'                                => 'wk',
    'wallisefutuna'                             => 'wf',
    'zimbabwe'                                  => 'zw',
    'zâmbia'                                   => 'zm',
    'África'                                   => '002',
    'Áfricaaustral'                            => '018',
    'Áfricacentral'                            => '017',
    'Áfricadosul'                              => 'za',
    'Áfricaocidental'                          => '011',
    'Áfricaoriental'                           => '014',
    'Ásia'                                     => 142,
    'Ásiacentral'                              => 143,
    'Ásiacentromeridional'                     => '062',
    'Ásiadosul'                                => '034',
    'Ásiaocidental'                            => 145,
    'Ásiaoriental'                             => '030',
    'Áustria'                                  => 'at',
    'Índia'                                    => 'in',
);

1;

