# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network.aio import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementVirtualRoutersOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_routers_begin_delete(self, resource_group):
        response = await (
            await self.client.virtual_routers.begin_delete(
                resource_group_name=resource_group.name,
                virtual_router_name="str",
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_routers_get(self, resource_group):
        response = await self.client.virtual_routers.get(
            resource_group_name=resource_group.name,
            virtual_router_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_routers_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.virtual_routers.begin_create_or_update(
                resource_group_name=resource_group.name,
                virtual_router_name="str",
                parameters={
                    "etag": "str",
                    "hostedGateway": {"id": "str"},
                    "hostedSubnet": {"id": "str"},
                    "id": "str",
                    "location": "str",
                    "name": "str",
                    "peerings": [{"id": "str"}],
                    "provisioningState": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                    "virtualRouterAsn": 0,
                    "virtualRouterIps": ["str"],
                },
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_routers_list_by_resource_group(self, resource_group):
        response = self.client.virtual_routers.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_virtual_routers_list(self, resource_group):
        response = self.client.virtual_routers.list(
            api_version="2024-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
