/*
 * UosSylph -- E-Mail client library
 * Copyright (C) 2020 ~ 2021 Uniontech Software Technology Co.,Ltd.
 *
 * Author:     shuiqucheng<shuiqucheng@uniontech.com>
 *
 * Maintainer: shuiqucheng<shuiqucheng@uniontech.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "uosfilter.h"

gint uos_filter_apply(GSList *fltlist,
                      const gchar *file,
                      UosFilterInfo *fltinfo){
    return filter_apply(fltlist,file,fltinfo);
}

gint uos_filter_apply_msginfo(GSList *fltlist,
                              UosMsgInfo *msginfo,
                              UosFilterInfo *fltinfo){
    return filter_apply_msginfo(fltlist,msginfo,fltinfo);
}

gint uos_filter_action_exec(UosFilterRule *rule,
                            UosMsgInfo *msginfo,
                            const gchar *file,
                            UosFilterInfo *fltinfo){
    return filter_action_exec(rule,msginfo,file,fltinfo);
}


gboolean uos_filter_match_rule(UosFilterRule *rule,
                               UosMsgInfo *msginfo,
                               GSList *hlist,
                               UosFilterInfo *fltinfo){
    return filter_match_rule(rule,msginfo,hlist,fltinfo);
}

gboolean uos_filter_rule_requires_full_headers(UosFilterRule *rule){
    return filter_rule_requires_full_headers(rule);
}

GSList *uos_filter_user_xml_node_to_filter_list(GNode *node){
    return filter_user_xml_node_to_filter_list(node);
}

GSList *uos_filter_xml_node_to_filter_list(GNode *node){
    return filter_xml_node_to_filter_list(node);
}

GSList *uos_filter_read_file(const gchar *file){
    return filter_read_file(file);
}

void uos_filter_read_config(void){
    filter_read_config();
}

void uos_filter_write_file(GSList *list,
                           const gchar *file){
    filter_write_file(list,file);
}

void uos_filter_write_config(void){
    filter_write_config();
}

gchar *uos_filter_get_str(UosFilterRule *rule){
    return filter_get_str(rule);
}

UosFilterRule *uos_filter_read_str(const gchar *str){
    return filter_read_str(str);
}


void uos_filter_set_addressbook_func(UosFilterInAddressBookFunc func){
    filter_set_addressbook_func(func);
}


UosFilterInAddressBookFunc uos_filter_get_addressbook_func(void){
    return filter_get_addressbook_func();
}


UosFilterUser *uos_filter_user_new(const gchar *name, //add by shui
                                   const gchar *type,
                                   GSList *rules){
    return filter_user_new(name, type,rules);
}



UosFilterRule *uos_filter_rule_new(const gchar *name,
                                   UosFilterBoolOp bool_op,
                                   GSList *cond_list,
                                   GSList *action_list){
    return filter_rule_new(name,bool_op,cond_list,action_list);
}

UosFilterCond *uos_filter_cond_new(UosFilterCondType type,
                                   UosFilterMatchType match_type,
                                   UosFilterMatchFlag match_flag,
                                   const gchar *header,
                                   const gchar *value,
                                   const gchar *reserve){
    return filter_cond_new(type,match_type,match_flag,header,value,reserve);
}

UosFilterAction *uos_filter_action_new(UosFilterActionType type,
                                       const gchar *str){
    return filter_action_new(type,str);
}

UosFilterAction *uos_filter_action_new_self(UosFilterActionType type, //add by shui
                                            const gchar *str,
                                            gint ivalue,
                                            const gchar *reserve){
    return filter_action_new_self(type, str,ivalue,reserve);
}

UosFilterInfo *uos_filter_info_new(void){
    return filter_info_new();
}


UosFilterRule *uos_filter_junk_rule_create(UosPrefsAccount *account,
                                           UosFolderItem *default_junk,
                                           gboolean is_manual){
    return filter_junk_rule_create(account,default_junk,is_manual);
}


void uos_filter_rule_rename_dest_path(UosFilterRule *rule,
                                      const gchar *old_path,
                                      const gchar *new_path){
    filter_rule_rename_dest_path(rule,old_path,new_path);
}

void uos_filter_rule_delete_action_by_dest_path(UosFilterRule *rule,
                                                const gchar *path){
    filter_rule_delete_action_by_dest_path(rule,path);
}

void uos_filter_list_rename_path(const gchar *old_path,
                                 const gchar *new_path){
    filter_list_rename_path(old_path,new_path);
}

void uos_filter_list_delete_path(const gchar *path){
    filter_list_delete_path(path);
}

void uos_filter_rule_match_type_str_to_enum(const gchar *type_str,
                                            UosFilterMatchType *type,
                                            UosFilterMatchFlag *flag){
    filter_rule_match_type_str_to_enum(type_str,type,flag);
}


void uos_filter_get_keyword_from_msg(UosMsgInfo *msginfo,
                                     gchar **header,
                                     gchar **key,
                                     UosFilterCreateType type){
    filter_get_keyword_from_msg(msginfo,header,key,type);
}

void uos_filter_rule_list_free(GSList *fltlist){
    filter_rule_list_free(fltlist);
}

void uos_filter_rule_free(UosFilterRule *rule){
    filter_rule_free(rule);
}

void uos_filter_user_free(UosFilterUser *user){
    filter_user_free(user);
}

void uos_filter_cond_list_free(GSList *cond_list){
    filter_cond_list_free(cond_list);
}

void uos_filter_action_list_free(GSList *action_list){
    filter_action_list_free(action_list);
}

void uos_filter_info_free(UosFilterInfo *info){
    filter_info_free(info);
}
