## Copyright (C) 1993,1994 by the author(s).
# 
# This software is published in the hope that it will be useful, but
# WITHOUT ANY WARRANTY for any part of this software to work correctly
# or as described in the manuals. See the ShapeTools Public License
# for details.
#
# Permission is granted to use, copy, modify, or distribute any part of
# this software but only under the conditions described in the ShapeTools 
# Public License. A copy of this license is supposed to have been given
# to you along with ShapeTools in a file named LICENSE. Among other
# things, this copyright notice and the Public License must be
# preserved on all copies.

#
# Author Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
#
# $Header: rmhist.sh[3.2] Wed Jan 26 18:35:43 1994 andy@cs.tu-berlin.de frozen $
#
# remove a history

myself=`basename $0`

usage () {
  echo "usage: $myself [-f] [-h] [-q] [-v] names"
}

trapexit () {
  exit 1
}

perror () {
  echo 1>&2 $*
}

trap trapexit 1 2 3 15 

argc=$#
force=false
quiet=false

while [ $argc -gt 0 ]
do
  i=$1
  shift
  argc=`expr $argc - 1`
  case $i in
    -f)
      force=true
      quiet=true
      ;;
    -h)
      usage
      exit 0;;
    -v)
      echo This is '$myself-3.2 (Tue Aug 23 17:59:18 1994 by andy@cs.tu-berlin.de).'
      exit 0;;
    -q)
      quiet=true
      ;;
    -*)
      perror invalid option $i
      usage
      exit 1;;
    *)
      # ToDo: check if name contanins path
      if [ $quiet = false ]
      then
	echo -n "Really remove history $i ? [y] > "
	read input
	if [ "$input" = "no" -o "$input" = "n" ]
	  then
	    echo "history $i not removed"
	    exit 1
	fi
      fi
      if [ $force = true ]
      then
        rm -f AtFS/Data/$i AtFS/Attr/$i $i 2> /dev/null
      else
        rm AtFS/Data/$i AtFS/Attr/$i $i 2> /dev/null
      fi
  esac
done

exit 0
