/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.snative;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.swift.exceptions.SwiftException;
import org.apache.hadoop.fs.swift.exceptions.SwiftInternalStateException;
import org.apache.hadoop.fs.swift.snative.SwiftNativeFileSystemStore;
import org.apache.hadoop.fs.swift.util.SwiftUtils;

class SwiftNativeOutputStream
extends OutputStream {
    public static final int ATTEMPT_LIMIT = 3;
    private long filePartSize;
    private static final Log LOG = LogFactory.getLog(SwiftNativeOutputStream.class);
    private Configuration conf;
    private String key;
    private File backupFile;
    private OutputStream backupStream;
    private SwiftNativeFileSystemStore nativeStore;
    private boolean closed;
    private int partNumber;
    private long blockOffset;
    private long bytesWritten;
    private long bytesUploaded;
    private boolean partUpload = false;
    final byte[] oneByte = new byte[1];

    public SwiftNativeOutputStream(Configuration conf, SwiftNativeFileSystemStore nativeStore, String key, long partSizeKB) throws IOException {
        this.conf = conf;
        this.key = key;
        this.backupFile = this.newBackupFile();
        this.nativeStore = nativeStore;
        this.backupStream = new BufferedOutputStream(new FileOutputStream(this.backupFile));
        this.partNumber = 1;
        this.blockOffset = 0L;
        this.filePartSize = 1024L * partSizeKB;
    }

    private File newBackupFile() throws IOException {
        File dir = new File(this.conf.get("hadoop.tmp.dir"));
        if (!dir.mkdirs() && !dir.exists()) {
            throw new SwiftException("Cannot create Swift buffer directory: " + dir);
        }
        File result = File.createTempFile("output-", ".tmp", dir);
        result.deleteOnExit();
        return result;
    }

    @Override
    public void flush() throws IOException {
        this.backupStream.flush();
    }

    private synchronized void verifyOpen() throws SwiftException {
        if (this.closed) {
            throw new SwiftException("Output stream is closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        try {
            this.closed = true;
            this.backupStream.close();
            this.backupStream = null;
            Path keypath = new Path(this.key);
            if (this.partUpload) {
                this.partUpload(true);
                this.nativeStore.createManifestForPartUpload(keypath);
            } else {
                this.uploadOnClose(keypath);
            }
        }
        finally {
            this.delete(this.backupFile);
            this.backupFile = null;
        }
        assert (this.backupStream == null) : "backup stream has been reopened";
    }

    private void uploadOnClose(Path keypath) throws IOException {
        boolean uploadSuccess = false;
        int attempt = 0;
        while (!uploadSuccess) {
            try {
                this.bytesUploaded += this.uploadFileAttempt(keypath, ++attempt);
                uploadSuccess = true;
            }
            catch (IOException e) {
                LOG.info((Object)("Upload failed " + e), (Throwable)e);
                if (attempt <= 3) continue;
                throw e;
            }
        }
    }

    private long uploadFileAttempt(Path keypath, int attempt) throws IOException {
        long uploadLen = this.backupFile.length();
        SwiftUtils.debug(LOG, "Closing write of file %s; localfile=%s of length %d - attempt %d", this.key, this.backupFile, uploadLen, attempt);
        this.nativeStore.uploadFile(keypath, new FileInputStream(this.backupFile), uploadLen);
        return uploadLen;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            LOG.warn((Object)"stream not closed");
        }
        if (this.backupFile != null) {
            LOG.warn((Object)("Leaking backing file " + this.backupFile));
        }
    }

    private void delete(File file) {
        if (file != null) {
            SwiftUtils.debug(LOG, "deleting %s", file);
            if (!file.delete()) {
                LOG.warn((Object)("Could not delete " + file));
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByte[0] = (byte)b;
        this.write(this.oneByte, 0, 1);
    }

    @Override
    public synchronized void write(byte[] buffer, int offset, int len) throws IOException {
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            throw new IndexOutOfBoundsException("Invalid offset/length for write");
        }
        this.verifyOpen();
        SwiftUtils.debug(LOG, " write(offset=%d, len=%d)", offset, len);
        while (this.blockOffset + (long)len >= this.filePartSize) {
            int subWriteLen = (int)(this.filePartSize - this.blockOffset);
            if (subWriteLen < 0 || subWriteLen > len) {
                throw new SwiftInternalStateException("Invalid subwrite len: " + subWriteLen + " -buffer len: " + len);
            }
            this.writeToBackupStream(buffer, offset, subWriteLen);
            offset += subWriteLen;
            len -= subWriteLen;
            this.partUpload(false);
        }
        this.writeToBackupStream(buffer, offset, len);
    }

    private void writeToBackupStream(byte[] buffer, int offset, int len) throws IOException {
        assert (len >= 0) : "remainder to write is negative";
        SwiftUtils.debug(LOG, " writeToBackupStream(offset=%d, len=%d)", offset, len);
        if (len == 0) {
            return;
        }
        this.backupStream.write(buffer, offset, len);
        this.blockOffset += (long)len;
        this.bytesWritten += (long)len;
    }

    private void partUpload(boolean closingUpload) throws IOException {
        if (this.backupStream != null) {
            this.backupStream.close();
        }
        if (closingUpload && this.partUpload && this.backupFile.length() == 0L) {
            SwiftUtils.debug(LOG, "skipping upload of 0 byte final partition", new Object[0]);
            this.delete(this.backupFile);
        } else {
            this.partUpload = true;
            boolean uploadSuccess = false;
            int attempt = 0;
            while (!uploadSuccess) {
                try {
                    this.bytesUploaded += this.uploadFilePartAttempt(++attempt);
                    uploadSuccess = true;
                }
                catch (IOException e) {
                    LOG.info((Object)("Upload failed " + e), (Throwable)e);
                    if (attempt <= 3) continue;
                    throw e;
                }
            }
            this.delete(this.backupFile);
            ++this.partNumber;
            this.blockOffset = 0L;
            if (!closingUpload) {
                this.backupFile = this.newBackupFile();
                this.backupStream = new BufferedOutputStream(new FileOutputStream(this.backupFile));
            }
        }
    }

    private long uploadFilePartAttempt(int attempt) throws IOException {
        long uploadLen = this.backupFile.length();
        SwiftUtils.debug(LOG, "Uploading part %d of file %s; localfile=%s of length %d  - attempt %d", this.partNumber, this.key, this.backupFile, uploadLen, attempt);
        this.nativeStore.uploadFilePart(new Path(this.key), this.partNumber, new FileInputStream(this.backupFile), uploadLen);
        return uploadLen;
    }

    long getFilePartSize() {
        return this.filePartSize;
    }

    synchronized int getPartitionsWritten() {
        return this.partNumber - 1;
    }

    long getBytesWritten() {
        return this.bytesWritten;
    }

    long getBytesUploaded() {
        return this.bytesUploaded;
    }

    public String toString() {
        return "SwiftNativeOutputStream{, key='" + this.key + '\'' + ", backupFile=" + this.backupFile + ", closed=" + this.closed + ", filePartSize=" + this.filePartSize + ", partNumber=" + this.partNumber + ", blockOffset=" + this.blockOffset + ", partUpload=" + this.partUpload + ", nativeStore=" + this.nativeStore + ", bytesWritten=" + this.bytesWritten + ", bytesUploaded=" + this.bytesUploaded + '}';
    }
}

