/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.http;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.swift.exceptions.SwiftConnectionClosedException;
import org.apache.hadoop.fs.swift.util.SwiftUtils;

public class HttpInputStreamWithRelease
extends InputStream {
    private static final Log LOG = LogFactory.getLog(HttpInputStreamWithRelease.class);
    private final URI uri;
    private HttpMethod method;
    private volatile boolean released;
    private volatile boolean dataConsumed;
    private InputStream inStream;
    private final Exception constructionStack;
    private String reasonClosed = "unopened";

    public HttpInputStreamWithRelease(URI uri, HttpMethod method) throws IOException {
        this.uri = uri;
        this.method = method;
        Exception exception = this.constructionStack = LOG.isDebugEnabled() ? new Exception("stack") : null;
        if (method == null) {
            throw new IllegalArgumentException("Null 'method' parameter ");
        }
        try {
            this.inStream = method.getResponseBodyAsStream();
        }
        catch (IOException e) {
            this.inStream = new ByteArrayInputStream(new byte[0]);
            throw this.releaseAndRethrow("getResponseBodyAsStream() in constructor -" + e, e);
        }
    }

    @Override
    public void close() throws IOException {
        this.release("close()", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean release(String reason, Exception ex) throws IOException {
        if (!this.released) {
            this.reasonClosed = reason;
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Releasing connection to " + this.uri + ":  " + reason), (Throwable)ex);
                }
                if (this.method != null) {
                    if (!this.dataConsumed) {
                        this.method.abort();
                    }
                    this.method.releaseConnection();
                }
                if (this.inStream != null) {
                    this.inStream.close();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.released = true;
                this.dataConsumed = true;
            }
        }
        return false;
    }

    private IOException releaseAndRethrow(String operation, IOException ex) {
        block2: {
            try {
                this.release(operation, ex);
            }
            catch (IOException ioe) {
                LOG.debug((Object)("Exception during release: " + operation + " - " + ioe), (Throwable)ioe);
                if (ex != null) break block2;
                ex = ioe;
            }
        }
        return ex;
    }

    private synchronized void assumeNotReleased() throws SwiftConnectionClosedException {
        if (this.released || this.inStream == null) {
            throw new SwiftConnectionClosedException(this.reasonClosed);
        }
    }

    @Override
    public int available() throws IOException {
        this.assumeNotReleased();
        try {
            return this.inStream.available();
        }
        catch (IOException e) {
            throw this.releaseAndRethrow("available() failed -" + e, e);
        }
    }

    @Override
    public int read() throws IOException {
        this.assumeNotReleased();
        int read = 0;
        try {
            read = this.inStream.read();
        }
        catch (EOFException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("EOF exception " + e), (Throwable)e);
            }
            read = -1;
        }
        catch (IOException e) {
            throw this.releaseAndRethrow("read()", e);
        }
        if (read < 0) {
            this.dataConsumed = true;
            this.release("read() -all data consumed", null);
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read;
        SwiftUtils.validateReadArgs(b, off, len);
        this.assumeNotReleased();
        try {
            read = this.inStream.read(b, off, len);
        }
        catch (EOFException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("EOF exception " + e), (Throwable)e);
            }
            read = -1;
        }
        catch (IOException e) {
            throw this.releaseAndRethrow("read(b, off, " + len + ")", e);
        }
        if (read < 0) {
            this.dataConsumed = true;
            this.release("read() -all data consumed", null);
        }
        return read;
    }

    protected void finalize() {
        try {
            if (this.release("finalize()", this.constructionStack)) {
                LOG.warn((Object)("input stream of " + this.uri + " not closed properly -cleaned up in finalize()"));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Exception while releasing " + this.uri + "in finalizer"), (Throwable)e);
        }
    }

    public String toString() {
        return "HttpInputStreamWithRelease working with " + this.uri + " released=" + this.released + " dataConsumed=" + this.dataConsumed;
    }
}

