/***************************** LICENSE START ***********************************

 Copyright 2013 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef RequestPanelItem_H
#define RequestPanelItem_H

class Request;
class RequestPanel;
class Parameter;

#include "IconObject.h"

class RequestPanelItem 
{
public:
	RequestPanelItem(RequestPanel&,const Parameter&);
	virtual ~RequestPanelItem();
	 
	//virtual void getSizes(Dimension&,Dimension&);
	//virtual void setSizes(Dimension,Dimension);

	virtual void reset();
	virtual void update();
	virtual void apply();
	virtual void cleanup();
	virtual void set(Request&);

	virtual void grey();

	virtual long flags();
	virtual void refresh(const vector<string>&)=0;
    virtual void changed(const char* param,const vector<string>&) {}
    virtual void changed(const char* param,const string&) {}

	void checkDefault();
	
    virtual void adjustDisabled()=0;
	virtual void gray(bool)=0;
	virtual void mark(bool)=0;
	virtual bool hasDefaultTb()=0;
    virtual bool isDependent() const {return false;}

	virtual void edit(IconObject*);
	IconObjectH currentObject() {return currentObject_;}
	const Parameter& parameter() {return param_;}

protected:
    RequestPanel&    owner_;
	const Parameter& param_;
	IconObjectH      currentObject_;

	void decache();

private:
	RequestPanelItem(const RequestPanelItem&);
	RequestPanelItem& operator=(const RequestPanelItem&);

	vector<string> cache_;
};


#endif
