# 关于
这个文档用于说明分区策略, 问题, 以及重要选项.

# 手动分区操作
手动分区分为两部分, 后端部分位于 partman/ 目录, 它负责读取磁盘信息并执行实际的分区
操作, 通过 PartitionManager 来调用; 前端部分位于 ui/, 用于处理 UI 相关的操作, 与
后端的所有通信都是通过PartitionDelegate来完成.
 
初始时, PartitionManager 在工作线程中先扫描当前系统的所有磁盘信息,
并将结果(DeviceList)发送给 PartitionDelegate, 这时, 用户就可以开发做分区操作了.
用户分区完成后, PartitionDelegate 将用户的分区操作(OperationList)发送给
PartitionManager, 后者在工作线程中执行实际的分区过程, 并将结果返回给 UI 线程.

分区的最小单位是 MiB, 分区的起始点与结束点, 都是 MiB 的整数倍.

## msdos 分区表
只有在 UEFI Legacy/CSM 模式下, 才可以使用 msdos 分区.
只有4个主分区, 为了方便扩展, 在新建分区时, 如果"逻辑分区"是可用的, 应该默认使用"逻辑分区".
当然, 用户也可以手动更改为"主分区".

### 主分区
第一个主分区(包括扩展分区)的前部, 应该预留下大约 1MiB 的空间, 为了GRUB可以安装大的 module.

根分区或者 boot 分区, 不要求必须在主分区上面(windows 系统相反, 它会有这个要求).
但 boot 分区或根分区, 应该加入 boot 标记.

### 扩展分区
如果在新建逻辑分区时, 没有扩展分区, 需要自动为其创建.

如果移除了所有的逻辑分区, 应该同时移除扩展分区.

扩展分区与第一个逻辑分区之间, 也应该预留约1MiB的空白, 这个是用于 Extended Partition Boot
Record. 面且, 每个逻辑分区的开头, 也应该有1MiB的空间.

如果逻辑分区是对齐到开始点的, 它离开始点要有1MiB的空白空间; 如果是对齐到结束点的, 如果它的后面
还有逻辑分区的话, 它离结束点也应该有1MiB的空白空间.


## gpt 分区表
在UEFI 或者Legacy 模式下, 都可以使用gpt分区表.

EFI 分区(ESP), 应该添加boot及esp标记. 当加入这个标记后, EFI分区的Partition GUID就改成了
标准的GUID. 
新建EFI分区的最小限制是300MiB, 但是对于已有EFI分区, 最小容量可以是100MiB.

根分区及boot分区不需要添加boot标记.


# 自动分区
如果要使用自动分区, 需要在 settings.ini 中, 把 "skip_partition_page" 设置为 true;
把 "partition_do_auto_part" 设置为 true; 还可以修改一下默认的自动分区策略.

* "partition_auto_part_legacy_policy" 这个选项定义了 legacy 模式下的分区策略;
* "partition_auto_part_uefi_policy" 这个选项定义了 UEFI 模式下的分区策略;

下面是一个 UEFI 模式下的基本的分区策略,
`/boot/efi:efi:1Mib:300Mib;linux-swap:linux-swap:300Mib:4300Mib;/:ext4:4300Mib:100%`
* 创建一个分区, 分区之前由分号分隔.
* 每个分区的定义, 分成了四个部分, 挂载点:文件系统类型:分区起始位置:分区结束位置.
* 如果是交换分区, 可以把挂载点写成 linux-swap.
* 文件系统类型, 与在 settings.ini 其它选项中一样, 都是小写的.
* 分区的起始位置和分区结束位置, 使用的单位与 parted 命令中的相同, 可以是 15% 这样的百分比,
 可以是 4300 Mib 这样的具体的大小值.


# Bootloader
不同的引导方式, bootloader 的安装位置是有差异的.

## UEFI 模式
只需要将 grub-efi, shim 等一起复制到 EFI 文件系统的 deepin/ 目录里就可以了.
可以用 efibootmgr 来调整 UEFI 启动项的顺序.

## Legacy 模式
msdos 分区表里, 需要把 grub 的启动项写到第一个扇区, 才可以成为默认的引导器.

### 简单分区
当用户在简单分区选了一个 / 分区之后, 就应该把 bootloader 的安装位置修改为 / 分区所在的硬盘的
路径, 比如 /dev/sdb.

### 高级分区
在高级分区页面, 有一个手动选择 bootloaader 位置的页面. 在这个页面里, 首先列出来
在高级分区里显示的所有设备和分区, 并且忽略掉当前的 USB 引导设备.
如果用户在高级页面还没有选择任何分区, 默认的 bootloader 的位置是第一个可见的存储设备, 比如
/dev/sda. 当设置了 /boot 分区时, 应该优先选择 /boot 分区所在的设备; 如果没有 /boot 分区,
只设置了 / 分区, 应该优先选择 / 分区所在的设备.

如果用户手动选择了 bootloader 的位置, 应当以手动选择的位置为主; 但是, 如果高级分区页面的
分区信息及分区挂载点发生了变化, 应该基于以上策略重新自动选择.


# 限制
如果机器的内存小于 4GiB, 需要手动创建 swap 分区或者自动创建 swap 文件. 这时, 硬盘的最小容量
变成了12GiB. 推荐的硬盘容量是15GiB, 这个值也可以在配置文件里面调整.

当挂载点是 /, /usr, /boot等的时候, 分区是要被强制格式化的, 这个列表也可以在配置文件里面修改.

根分区 / 至少要有 8GiB的空间. /boot 分区默认是500MiB, EFI 分区默认是300MiB.

# 龙芯/申威
龙芯/申威平台上的启动分区, 要求是在第一个分区(/dev/sda1), 文件系统是 ext3, 现在存在两种情况.
* 有单独的 /boot 分区, 这时, / 分区的文件系统就可以选择为 ext4 了.
* 只有 / 分区, 没有独立的 /boot 分区, 这时 / 分区应该放在 /dev/sda1, 而且文件系统只能是
 ext3.

以上问题, 可以通过调整选项 "partition_boot_on_first_partition" 和
 "partition_first_boot_fs" 来做限制.

另外, 有一些挂载点是要被强制格式化了的, 相应的选项是 "partition_formatted_mount_points".
在龙芯/申威平台上, 可以把 /boot 从这个列表中移除.

# UEFI 兼容模式
当主板开启了 UEFI 兼容模式 (CSM) 时, 极有可能会出现启动方式混乱的问题.
兼容模式是指, 主板优先以 UEFI 模式, 查找硬盘上的所有分区, 看有没有 ESP 分区, 如果有, 就使用之;
如果没有, 就进入 fallback 模式, 读取硬盘的第一个扇区 (Master Boot Record), 并尝试载入里面
的 bootloader, 如果还是失败了, 此次启动就失败了, 并显示类似于
"No bootable media found" 的错误.

在开启了兼容模式的主板上, 如果刻录了系统的 U 盘是以 UEFI 方式启动的, 但是机器上的硬盘本来用的是
msdos 分区表, 而且里面已经有了系统, 那么就有极大的可能性, 这个系统是以 mbr 的方式来引导的.
为了尽可能的不破坏已有的系统, 安装器除了判断 /sys/firmware/efi 目录存在之外
(说明内核是以 UEFI 的方式启动的), 还应该判断硬盘上是否存在旧的系统, 如果有, 就应该忽略掉 UEFI
启动模式, 转而使用 mbr 的方式来启动.


# Tips
后台开始扫描磁盘之前, 会尽可能卸载所有可卸载的分区 (Debug 模式不会卸载交换分区). 如果卸载失败,
在分区页面里, 会隐藏正在被使用的分区.

容量的单位是 MiB, GiB, 但是为了保证与 deepin 文件管理器的统一, 现在改为MB和GB.

交换文件默认位于 /swapfile.

安装时, 安装介质所在的设备, 比如 /dev/sdb, 会在分区列表里面被隐藏掉.

高级分区界面上显示出来的 sda3 这样的分区路径, 并不是最终的路径, 因为这个分区编号只是简单计算出来
的, 并不是真实的编号; 最终, 在调用 libparted 做分区操作时, 会实时地调它的接口以确定一个分区的
真实的分区编号及路径.