(function (root, data) {
    var loaded, module;

    /* Load into AMD if desired */
    if (typeof define === 'function' && define.amd) {
        define(data);
        loaded = true;
    }

    /* Load into Cockpit locale */
    if (typeof cockpit === 'object') {
        cockpit.locale(data)
        loaded = true;
    }

    function transformAngular(data, prev) {
        var key, context, parts, value, result = { };
        for (key in data) {
            if (key === "")
                continue;
            parts = key.split("\u0004");
            value = data[key];
            if (parts[1]) {
                context = parts[0];
                key = parts[1];
            } else {
                context = "$$noContext";
                key = parts[0];
            }
            if (value[0] === null)
                value = value[1];
            else
                value = value.slice(1);
            if (!(key in result))
                result[key] = { };
            result[key][context] = value;
        }
        return angular.extend(prev, result);
    }

    /* Load into angular here */
    if (typeof angular === 'object') {
        try {
            module = angular.module(["gettext"]);
        } catch(ex) { console.log(ex); /* Either no angular or angular-gettext */ };
        if (module) {
            loaded = true;
            module.run(['gettextCatalog', function(gettextCatalog) {
                var lang = data[""]["language"];
                var prev = (gettextCatalog.getCurrentLanguage() == lang) ? gettextCatalog.strings : { };
                gettextCatalog.setStrings(lang, transformAngular(data, prev));
                gettextCatalog.setCurrentLanguage(lang);
            }]);
        }
    }

    if (!loaded)
        root.po = data;

/* The syntax of this line is important  by po2json */
}(this, {
 "": {'plural-forms':function(n) {
var nplurals, plural;
nplurals=1; plural=0;
return plural;
},
  "language": "zh_TW",
  "x-generator": "Zanata 4.6.2"
 },
 "Applications": [
  null,
  "應用程式"
 ],
 "Cancel": [
  null,
  "取消"
 ],
 "Checking for new applications": [
  null,
  "檢查新的應用程序"
 ],
 "Close": [
  null,
  "關閉"
 ],
 "Error": [
  null,
  "錯誤"
 ],
 "Go to Application": [
  null,
  "轉到應用程序"
 ],
 "Install": [
  null,
  "安裝"
 ],
 "Installing": [
  null,
  "安裝"
 ],
 "No applications installed or available": [
  null,
  "沒有安裝或可用的應用程序"
 ],
 "No description provided.": [
  null,
  "沒有提供說明。"
 ],
 "No installation package found for this application.": [
  null,
  "找不到此應用程序的安裝包。"
 ],
 "Ok": [
  null,
  "確定"
 ],
 "PackageKit crashed": [
  null,
  "PackageKit崩潰了"
 ],
 "Remove": [
  null,
  "移除"
 ],
 "Removing": [
  null,
  "移除"
 ],
 "Unknown Application": [
  null,
  "未知的申請"
 ],
 "Waiting for other programs to finish using the package manager...": [
  null,
  "等待其他程序完成使用包管理器..."
 ]
}));
