/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.authorization;

import com.sourceforge.knecs.dsm.authorization.AccessException;
import com.sourceforge.knecs.dsm.authorization.AuthService;
import com.sourceforge.knecs.dsm.authorization.DSIPrivilege;
import com.sourceforge.knecs.dsm.authorization.NormalizedAce;
import com.sourceforge.knecs.dsm.authorization.NormalizedAceList;
import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Logger;
import org.apache.webdav.lib.Ace;
import org.apache.webdav.lib.Privilege;
import org.apache.webdav.lib.properties.AclProperty;

public class DSIAuthService
implements AuthService {
    protected DSI mDSI = null;
    protected static Logger mLogger = LoggerUtils.getLogger();
    protected static String mUserPrincipalBaseURI;

    public DSIAuthService(DSI dsi) {
        this.mDSI = dsi;
    }

    public void close() {
        this.mDSI = null;
    }

    public boolean isAuthorized(Privilege privilege, String url, String userID) throws AccessException {
        try {
            NormalizedAceList nAces = this.getNormalizedPrivileges(url);
            boolean ret = nAces.isAuthorized(userID, privilege);
            mLogger.fine("isAuthorized " + userID + "@" + url + "=" + ret);
            return ret;
        }
        catch (Exception e) {
            mLogger.severe("DSI.aclProperty failed!\n" + e.toString() + "\n" + LoggerUtils.getStackTrace(e));
            throw new AccessException(e.toString());
        }
    }

    public boolean isAuthorized(String privilege, String url, String userID) throws AccessException {
        return this.isAuthorized(DSIPrivilege.convertDsiPrivilege(privilege), url, userID);
    }

    public static NormalizedAceList getNormalizedPrivileges(Ace[] aces, String path) {
        if (aces == null) {
            return null;
        }
        mLogger.fine("getNormalizedPrivileges @ " + path);
        NormalizedAceList ret = new NormalizedAceList(path);
        for (int i = 0; i < aces.length; ++i) {
            ret.mergeAce(aces[i]);
        }
        mLogger.fine("Finished getNormalizedPrivileges @ " + path);
        return ret;
    }

    public NormalizedAceList getNormalizedPrivileges(String url) throws Exception {
        Ace[] aces = this.getAces(url);
        return DSIAuthService.getNormalizedPrivileges(aces, this.mDSI.getPath());
    }

    public void addPrivilege(Privilege[] priv, String url) throws AccessException {
        this.addPrivilege(priv, url, this.mDSI.getUser());
    }

    public void addPrivilege(Privilege priv, String url, String userID) throws AccessException {
        Privilege[] privs = new Privilege[]{priv};
        this.addPrivilege(privs, url, userID);
    }

    public void addPrivilege(Privilege priv, String url) throws AccessException {
        Privilege[] privs = new Privilege[]{priv};
        this.addPrivilege(privs, url, this.mDSI.getUser());
    }

    public void addPrivilege(Privilege[] priv, String url, String userID) throws AccessException {
        this.addPrivilege(priv, url, userID, false);
    }

    public void addPrivilege(Privilege[] priv, String url, String userID, boolean deny) throws AccessException {
        String userPrin = DSIAuthService.getUserPrincipalURI(userID);
        try {
            Privilege[] expPriv;
            int i;
            Ace[] aces = this.getAces(url);
            if (aces == null) {
                aces = new Ace[]{};
            }
            Ace ace = null;
            Ace oppositeAce = null;
            for (i = 0; i < aces.length && (ace == null || oppositeAce == null); ++i) {
                if (aces[i].isNegative() == deny && !aces[i].isProtected() && !aces[i].isInherited() && aces[i].getPrincipal().equals(userPrin)) {
                    mLogger.fine("found ace for : " + userID);
                    ace = aces[i];
                }
                if (aces[i].isNegative() != !deny || aces[i].isProtected() || aces[i].isInherited() || !aces[i].getPrincipal().equals(userPrin)) continue;
                mLogger.fine("found opposite ace for : " + userID);
                oppositeAce = aces[i];
            }
            if (oppositeAce != null) {
                expPriv = this.expandPrivilegeForRemoval(priv);
                for (i = 0; i < expPriv.length; ++i) {
                    oppositeAce.removePrivilege(expPriv[i]);
                }
            }
            if (ace == null) {
                expPriv = this.expandPrivilegeForRemoval(priv);
                Ace[] oldAces = aces;
                aces = new Ace[oldAces.length + 1];
                System.arraycopy(oldAces, 0, aces, 0, oldAces.length);
                aces[oldAces.length] = ace = new Ace(userPrin, deny, false, false, null);
            }
            for (i = 0; i < priv.length; ++i) {
                mLogger.fine("trying to add privilege: " + priv[i] + " to ace");
                ace.addPrivilege(priv[i]);
            }
            this.saveAces(url, aces);
        }
        catch (Exception e) {
            mLogger.severe(e.toString());
            throw new AccessException(e.toString());
        }
    }

    public void testAddPrivilege(Privilege priv, String url, String userID) throws AccessException {
        try {
            String userPrin = DSIAuthService.getUserPrincipalURI(userID);
            Ace[] aces = new Ace[1];
            Ace ace = new Ace(userPrin, false, false, false, null);
            ace.addPrivilege(priv);
            aces[0] = ace;
            this.saveAces(url, aces);
        }
        catch (Exception e) {
            mLogger.severe(e.toString());
            throw new AccessException(e.toString());
        }
    }

    public void resetPrivileges(String url, NormalizedAceList aces) throws AccessException {
        mLogger.fine("Trying to reset all non-inherited ACLs for: " + url);
        try {
            Enumeration users = aces.getUsers();
            Vector<Ace> slideAcesV = new Vector<Ace>();
            while (users.hasMoreElements()) {
                String userPrin = DSIAuthService.getUserPrincipalURI((String)users.nextElement());
                NormalizedAce ace = aces.getAce(userPrin);
                Enumeration privs = ace.elements();
                Ace slideAceGrant = new Ace(userPrin, false, false, false, null);
                Ace slideAceDeny = new Ace(userPrin, true, false, false, null);
                boolean hasGrant = false;
                boolean hasDeny = false;
                while (privs.hasMoreElements()) {
                    DSIPrivilege priv = (DSIPrivilege)privs.nextElement();
                    mLogger.fine("examining element " + priv.getName() + " deny=" + priv.getDeny() + " inheritanceLvl=" + priv.getInheritanceLevel() + " for user " + userPrin);
                    if (priv.getInheritanceLevel() != 0) continue;
                    mLogger.fine("Adding privilege: " + priv.getName() + " for user: " + userPrin + " : " + priv.getDeny());
                    Privilege slidePriv = DSIPrivilege.convertDsiPrivilege(priv);
                    if (priv.getDeny()) {
                        slideAceDeny.addPrivilege(slidePriv);
                        hasDeny = true;
                        continue;
                    }
                    slideAceGrant.addPrivilege(slidePriv);
                    hasGrant = true;
                }
                if (hasGrant) {
                    slideAcesV.add(slideAceGrant);
                }
                if (!hasDeny) continue;
                slideAcesV.add(slideAceDeny);
            }
            int size = slideAcesV.size();
            Ace[] slideAces = new Ace[size];
            for (int i = 0; i < size; ++i) {
                slideAces[i] = (Ace)slideAcesV.elementAt(i);
            }
            this.saveAces(url, slideAces);
        }
        catch (Exception e) {
            mLogger.severe(LoggerUtils.getStackTrace(e));
            throw new AccessException(e.toString());
        }
    }

    public void removePrivilege(Privilege[] priv, String url) throws AccessException {
        this.removePrivilege(priv, url, this.mDSI.getUser());
    }

    public void removePrivilege(Privilege priv, String url) throws AccessException {
        Privilege[] privs = new Privilege[]{priv};
        this.removePrivilege(privs, url, this.mDSI.getUser());
    }

    public void removePrivilege(Privilege[] priv, String url, String userID) throws AccessException {
        Privilege[] expandedPriv = this.expandPrivilegeForRemoval(priv);
        String userPrin = DSIAuthService.getUserPrincipalURI(userID);
        try {
            Ace[] aces = this.getAces(url);
            if (aces == null) {
                throw new Exception("No privileges found for resource " + url);
            }
            boolean found = false;
            boolean denyPriv = false;
            for (int i = 0; i < aces.length; ++i) {
                if (aces[i].isProtected() || !aces[i].getPrincipal().equals(userPrin) && !userID.equals("all")) continue;
                if (aces[i].isInherited()) {
                    denyPriv = true;
                    this.denyPrivilege(priv, url, userID);
                } else {
                    mLogger.fine("found ace");
                    for (int j = 0; j < expandedPriv.length; ++j) {
                        aces[i].removePrivilege(expandedPriv[j]);
                        mLogger.fine(expandedPriv[j].getName() + " removed");
                    }
                }
                found = true;
            }
            if (!found) {
                throw new Exception("Privileges not found for user " + userID);
            }
            if (!denyPriv) {
                this.saveAces(url, aces);
            }
        }
        catch (Exception e) {
            mLogger.severe(e.toString());
            throw new AccessException(e.toString());
        }
    }

    public void removePrivilege(Privilege priv, String url, String userID) throws AccessException {
        Privilege[] privs = new Privilege[]{priv};
        this.removePrivilege(privs, url, userID);
    }

    public void denyPrivilege(Privilege[] priv, String url) throws AccessException {
        this.denyPrivilege(priv, url, this.mDSI.getUser());
    }

    public void denyPrivilege(Privilege priv, String url) throws AccessException {
        Privilege[] privs = new Privilege[]{priv};
        this.denyPrivilege(privs, url, this.mDSI.getUser());
    }

    public void denyPrivilege(Privilege[] priv, String url, String userID) throws AccessException {
        this.addPrivilege(priv, url, userID, true);
    }

    public void denyPrivilege(Privilege priv, String url, String userID) throws AccessException {
        Privilege[] privs = new Privilege[]{priv};
        this.denyPrivilege(privs, url, userID);
    }

    public static String getCmcsUserId(String userPrincipal) {
        String authUser = DSIAuthService.getAuthUserURI();
        String[] types = new String[]{"all", "authenticated", "property", "self", authUser};
        String userID = userPrincipal;
        boolean found = false;
        for (int i = 0; i < types.length && !found; ++i) {
            if (!types[i].equals(userPrincipal)) continue;
            found = true;
        }
        if (!found && userPrincipal.startsWith(mUserPrincipalBaseURI)) {
            userID = userPrincipal.substring(mUserPrincipalBaseURI.length());
        }
        return userID;
    }

    public static String getUserPrincipalURI(String userID) {
        String userPrin = userID;
        mLogger.fine("user ID = " + userID);
        String authUser = DSIAuthService.getAuthUserURI();
        String[] types = new String[]{"all", "authenticated", "property", "self", authUser};
        if (userID == null || userID.equals("unauthenticated") || userID.equals("")) {
            userPrin = "all";
        } else {
            boolean found = false;
            for (int i = 0; i < types.length && !found; ++i) {
                if (!types[i].equals(userID)) continue;
                found = true;
            }
            if (!found && !userID.startsWith("/")) {
                userPrin = mUserPrincipalBaseURI + "/" + userID;
            }
        }
        mLogger.fine("user principal URI: " + userPrin);
        return userPrin;
    }

    public static String getAuthUserURI() {
        return "authenticated";
    }

    private Privilege[] expandPrivilegeForRemoval(Privilege[] privs) {
        int i;
        Vector<Privilege> newPrivs = new Vector<Privilege>();
        for (i = 0; i < privs.length; ++i) {
            newPrivs.add(privs[i]);
            if (privs[i].equals(Privilege.ALL)) {
                newPrivs.add(Privilege.READ);
                newPrivs.add(Privilege.WRITE);
                newPrivs.add(Privilege.READ_ACL);
                newPrivs.add(Privilege.WRITE_ACL);
                break;
            }
            if (privs[i].equals(Privilege.READ) && !newPrivs.contains(Privilege.READ_ACL)) {
                newPrivs.add(Privilege.READ_ACL);
                continue;
            }
            if (!privs[i].equals(Privilege.READ_ACL) || newPrivs.contains(Privilege.READ)) continue;
            newPrivs.add(Privilege.READ);
        }
        int size = newPrivs.size();
        Privilege[] ret = new Privilege[size];
        for (i = 0; i < size; ++i) {
            ret[i] = (Privilege)newPrivs.elementAt(i);
        }
        return ret;
    }

    private void saveAces(String url, Ace[] aces) throws Exception {
        if (url.endsWith("/") || url.endsWith("\\")) {
            url = url.substring(0, url.length() - 1);
        }
        this.mDSI.setURL(url);
        mLogger.fine("trying to call dsi.putACL");
        DSIAuthService.showAces(url, aces);
        this.mDSI.putACL(aces);
        mLogger.fine("putACL completed successfully");
    }

    protected Ace[] getAces(String url) throws Exception {
        this.mDSI.setURL(url);
        mLogger.fine("trying to get current ACL properties for " + url);
        AclProperty acl = this.mDSI.getACL();
        mLogger.fine("got ACLs successfully");
        if (acl == null) {
            throw new Exception("Error: dsi.getACL didn't return an AclProperty!");
        }
        return acl.getAces();
    }

    protected void slideAclHack(String url) throws Exception {
        this.mDSI.setURL(url);
        this.mDSI.exists();
    }

    private static void showAces(String path, Ace[] aces) {
        if (aces == null || aces.length == 0) {
            mLogger.fine("ACL for " + path + " is empty.");
            return;
        }
        mLogger.fine("ACL for " + path + ":");
        mLogger.fine("------------------------------------------------------------");
        for (int i = 0; i < aces.length; ++i) {
            Ace ace = aces[i];
            mLogger.fine((!ace.isNegative() ? "granted" : "denied") + " to " + ace.getPrincipal() + " " + "   (" + (ace.isProtected() ? "protected" : "not protected") + ")" + "   (" + (ace.isInherited() ? "inherited from '" + ace.getInheritedFrom() + "'" : "not inherited") + ")");
            Enumeration privileges = ace.enumeratePrivileges();
            if (privileges == null) {
                mLogger.fine("priv enumeration is null!");
            }
            while (privileges.hasMoreElements()) {
                Privilege priv = (Privilege)privileges.nextElement();
                if (priv == null) {
                    mLogger.fine("priv is null!");
                }
                mLogger.fine("   " + priv.getNamespace() + priv.getName() + "   " + (priv.getParameter() == null ? "" : "(" + priv.getParameter() + ")"));
            }
        }
        mLogger.fine("------------------------------------------------------------");
    }

    static {
        String path = CMCSProperties.getServerPath();
        mUserPrincipalBaseURI = path == null ? "/users" : path + "/users";
    }
}

