; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --include-generated-funcs --version 5
; RUN: opt -passes="ipsccp<func-spec>" -force-specialization -funcspec-for-literal-constant=false -S < %s | FileCheck %s

define i64 @main(i64 %x, i64 %y, i1 %flag) {
entry:
  br i1 %flag, label %plus, label %minus

plus:
  %cmp0 = call i64 @compute(i64 %x, i64 %y, ptr @plus, ptr @minus)
  br label %merge

minus:
  %cmp1 = call i64 @compute(i64 %x, i64 %y, ptr @minus, ptr @plus)
  br label %merge

merge:
  %ph = phi i64 [ %cmp0, %plus ], [ %cmp1, %minus]
  %cmp2 = call i64 @compute(i64 %ph, i64 42, ptr @plus, ptr @minus)
  ret i64 %cmp2
}

define internal i64 @compute(i64 %x, i64 %y, ptr %binop1, ptr %binop2) {
entry:
  %op0 = call i64 %binop1(i64 %x, i64 %y)
  %op1 = call i64 %binop2(i64 %x, i64 %y)
  %op2 = call i64 @compute(i64 %x, i64 %y, ptr %binop1, ptr @plus)
  %add0 = add i64 %op0, %op1
  %add1 = add i64 %add0, %op2
  %div = sdiv i64 %add1, %x
  %sub = sub i64 %div, %y
  %mul = mul i64 %sub, 2
  ret i64 %mul
}

define internal i64 @plus(i64 %x, i64 %y) {
entry:
  %add = add i64 %x, %y
  ret i64 %add
}

define internal i64 @minus(i64 %x, i64 %y) {
entry:
  %sub = sub i64 %x, %y
  ret i64 %sub
}



; CHECK-LABEL: define i64 @main(
; CHECK-SAME: i64 [[X:%.*]], i64 [[Y:%.*]], i1 [[FLAG:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    br i1 [[FLAG]], label %[[PLUS:.*]], label %[[MINUS:.*]]
; CHECK:       [[PLUS]]:
; CHECK-NEXT:    [[CMP0:%.*]] = call i64 @compute.specialized.2(i64 [[X]], i64 [[Y]], ptr @plus, ptr @minus)
; CHECK-NEXT:    br label %[[MERGE:.*]]
; CHECK:       [[MINUS]]:
; CHECK-NEXT:    [[CMP1:%.*]] = call i64 @compute.specialized.3(i64 [[X]], i64 [[Y]], ptr @minus, ptr @plus)
; CHECK-NEXT:    br label %[[MERGE]]
; CHECK:       [[MERGE]]:
; CHECK-NEXT:    [[PH:%.*]] = phi i64 [ [[CMP0]], %[[PLUS]] ], [ [[CMP1]], %[[MINUS]] ]
; CHECK-NEXT:    [[CMP2:%.*]] = call i64 @compute.specialized.2(i64 [[PH]], i64 42, ptr @plus, ptr @minus)
; CHECK-NEXT:    ret i64 [[CMP2]]
;
;
; CHECK-LABEL: define internal i64 @plus(
; CHECK-SAME: i64 [[X:%.*]], i64 [[Y:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[ADD:%.*]] = add i64 [[X]], [[Y]]
; CHECK-NEXT:    ret i64 [[ADD]]
;
;
; CHECK-LABEL: define internal i64 @minus(
; CHECK-SAME: i64 [[X:%.*]], i64 [[Y:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[SUB:%.*]] = sub i64 [[X]], [[Y]]
; CHECK-NEXT:    ret i64 [[SUB]]
;
;
; CHECK-LABEL: define internal i64 @compute.specialized.1(
; CHECK-SAME: i64 [[X:%.*]], i64 [[Y:%.*]], ptr [[BINOP1:%.*]], ptr [[BINOP2:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[OP1:%.*]] = call i64 [[BINOP1]](i64 [[X]], i64 [[Y]])
; CHECK-NEXT:    [[OP0:%.*]] = call i64 @plus(i64 [[X]], i64 [[Y]])
; CHECK-NEXT:    [[OP2:%.*]] = call i64 @compute.specialized.1(i64 [[X]], i64 [[Y]], ptr [[BINOP1]], ptr @plus)
; CHECK-NEXT:    [[ADD0:%.*]] = add i64 [[OP1]], [[OP0]]
; CHECK-NEXT:    [[ADD1:%.*]] = add i64 [[ADD0]], [[OP2]]
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i64 [[ADD1]], [[X]]
; CHECK-NEXT:    [[SUB:%.*]] = sub i64 [[DIV]], [[Y]]
; CHECK-NEXT:    [[MUL:%.*]] = mul i64 [[SUB]], 2
; CHECK-NEXT:    ret i64 [[MUL]]
;
;
; CHECK-LABEL: define internal i64 @compute.specialized.2(
; CHECK-SAME: i64 [[X:%.*]], i64 [[Y:%.*]], ptr [[BINOP1:%.*]], ptr [[BINOP2:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[OP0:%.*]] = call i64 @plus(i64 [[X]], i64 [[Y]])
; CHECK-NEXT:    [[OP1:%.*]] = call i64 @minus(i64 [[X]], i64 [[Y]])
; CHECK-NEXT:    [[OP2:%.*]] = call i64 @compute.specialized.1(i64 [[X]], i64 [[Y]], ptr @plus, ptr @plus)
; CHECK-NEXT:    [[ADD0:%.*]] = add i64 [[OP0]], [[OP1]]
; CHECK-NEXT:    [[ADD1:%.*]] = add i64 [[ADD0]], [[OP2]]
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i64 [[ADD1]], [[X]]
; CHECK-NEXT:    [[SUB:%.*]] = sub i64 [[DIV]], [[Y]]
; CHECK-NEXT:    [[MUL:%.*]] = mul i64 [[SUB]], 2
; CHECK-NEXT:    ret i64 [[MUL]]
;
;
; CHECK-LABEL: define internal i64 @compute.specialized.3(
; CHECK-SAME: i64 [[X:%.*]], i64 [[Y:%.*]], ptr [[BINOP1:%.*]], ptr [[BINOP2:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[OP0:%.*]] = call i64 @minus(i64 [[X]], i64 [[Y]])
; CHECK-NEXT:    [[OP1:%.*]] = call i64 @plus(i64 [[X]], i64 [[Y]])
; CHECK-NEXT:    [[OP2:%.*]] = call i64 @compute.specialized.3(i64 [[X]], i64 [[Y]], ptr @minus, ptr @plus)
; CHECK-NEXT:    [[ADD0:%.*]] = add i64 [[OP0]], [[OP1]]
; CHECK-NEXT:    [[ADD1:%.*]] = add i64 [[ADD0]], [[OP2]]
; CHECK-NEXT:    [[DIV:%.*]] = sdiv i64 [[ADD1]], [[X]]
; CHECK-NEXT:    [[SUB:%.*]] = sub i64 [[DIV]], [[Y]]
; CHECK-NEXT:    [[MUL:%.*]] = mul i64 [[SUB]], 2
; CHECK-NEXT:    ret i64 [[MUL]]
;
