; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN:  llc -amdgpu-scalarize-global-loads=false  -mtriple=amdgcn < %s | FileCheck --check-prefixes=GCN-NOHSA,FUNC,SI-NOHSA %s
; RUN:  llc -amdgpu-scalarize-global-loads=false  -mtriple=amdgcn-amdhsa -mcpu=kaveri < %s | FileCheck --check-prefixes=GCN-HSA,FUNC,GCNX3-HSA %s
; RUN:  llc -amdgpu-scalarize-global-loads=false  -mtriple=amdgcn -mcpu=tonga -mattr=-flat-for-global < %s | FileCheck --check-prefixes=GCN-NOHSA,FUNC,GCNX3-NOHSA %s

; RUN:  llc -amdgpu-scalarize-global-loads=false  -mtriple=r600 -mcpu=redwood < %s | FileCheck --check-prefixes=R600,FUNC %s
; RUN:  llc -amdgpu-scalarize-global-loads=false  -mtriple=r600 -mcpu=cayman < %s | FileCheck --check-prefixes=R600,FUNC %s

define amdgpu_kernel void @global_load_f32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_f32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCN-HSA-LABEL: global_load_f32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GCN-HSA-NEXT:    s_add_i32 s12, s12, s17
; GCN-HSA-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-HSA-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCN-HSA-NEXT:    flat_load_dword v2, v[0:1]
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, s0
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, s1
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    flat_store_dword v[0:1], v2
; GCN-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_f32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dword v0, off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    buffer_store_dword v0, off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
entry:
  %tmp0 = load float, ptr addrspace(1) %in
  store float %tmp0, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v2f32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v2f32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCN-HSA-LABEL: global_load_v2f32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GCN-HSA-NEXT:    s_add_i32 s12, s12, s17
; GCN-HSA-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-HSA-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCN-HSA-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, s0
; GCN-HSA-NEXT:    v_mov_b32_e32 v3, s1
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GCN-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v2f32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx2 v[0:1], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
entry:
  %tmp0 = load <2 x float>, ptr addrspace(1) %in
  store <2 x float> %tmp0, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v3f32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v3f32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:8
; SI-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCN-HSA-LABEL: global_load_v3f32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GCN-HSA-NEXT:    s_add_i32 s12, s12, s17
; GCN-HSA-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-HSA-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCN-HSA-NEXT:    flat_load_dwordx3 v[0:2], v[0:1]
; GCN-HSA-NEXT:    v_mov_b32_e32 v3, s0
; GCN-HSA-NEXT:    v_mov_b32_e32 v4, s1
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    flat_store_dwordx3 v[3:4], v[0:2]
; GCN-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v3f32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx3 v[0:2], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx3 v[0:2], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
entry:
  %tmp0 = load <3 x float>, ptr addrspace(1) %in
  store <3 x float> %tmp0, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v4f32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v4f32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCN-HSA-LABEL: global_load_v4f32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GCN-HSA-NEXT:    s_add_i32 s12, s12, s17
; GCN-HSA-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-HSA-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCN-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCN-HSA-NEXT:    v_mov_b32_e32 v4, s0
; GCN-HSA-NEXT:    v_mov_b32_e32 v5, s1
; GCN-HSA-NEXT:    s_waitcnt vmcnt(0)
; GCN-HSA-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v4f32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
entry:
  %tmp0 = load <4 x float>, ptr addrspace(1) %in
  store <4 x float> %tmp0, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v8f32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v8f32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(1)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(1)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_endpgm
;
; GCN-HSA-LABEL: global_load_v8f32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GCN-HSA-NEXT:    s_add_i32 s12, s12, s17
; GCN-HSA-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-HSA-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    s_add_u32 s4, s2, 16
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCN-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCN-HSA-NEXT:    v_mov_b32_e32 v5, s5
; GCN-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCN-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCN-HSA-NEXT:    v_mov_b32_e32 v9, s1
; GCN-HSA-NEXT:    v_mov_b32_e32 v8, s0
; GCN-HSA-NEXT:    s_add_u32 s0, s0, 16
; GCN-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v11, s1
; GCN-HSA-NEXT:    v_mov_b32_e32 v10, s0
; GCN-HSA-NEXT:    s_waitcnt vmcnt(1)
; GCN-HSA-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(1)
; GCN-HSA-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; GCN-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v8f32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(1)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(1)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_endpgm
entry:
  %tmp0 = load <8 x float>, ptr addrspace(1) %in
  store <8 x float> %tmp0, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v9f32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v9f32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dword v8, off, s[8:11], 0 offset:32
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:32
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    s_endpgm
;
; GCN-HSA-LABEL: global_load_v9f32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GCN-HSA-NEXT:    s_add_i32 s12, s12, s17
; GCN-HSA-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-HSA-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    s_add_u32 s4, s2, 16
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCN-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCN-HSA-NEXT:    s_add_u32 s2, s2, 32
; GCN-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v4, s4
; GCN-HSA-NEXT:    v_mov_b32_e32 v7, s3
; GCN-HSA-NEXT:    v_mov_b32_e32 v5, s5
; GCN-HSA-NEXT:    v_mov_b32_e32 v6, s2
; GCN-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCN-HSA-NEXT:    flat_load_dword v14, v[6:7]
; GCN-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCN-HSA-NEXT:    s_add_u32 s2, s0, 32
; GCN-HSA-NEXT:    v_mov_b32_e32 v9, s1
; GCN-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v8, s0
; GCN-HSA-NEXT:    s_add_u32 s0, s0, 16
; GCN-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v11, s3
; GCN-HSA-NEXT:    v_mov_b32_e32 v13, s1
; GCN-HSA-NEXT:    v_mov_b32_e32 v10, s2
; GCN-HSA-NEXT:    v_mov_b32_e32 v12, s0
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    flat_store_dword v[10:11], v14
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    flat_store_dwordx4 v[12:13], v[4:7]
; GCN-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v9f32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dword v8, off, s[8:11], 0 offset:32
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dword v8, off, s[4:7], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_endpgm
entry:
  %tmp0 = load <9 x float>, ptr addrspace(1) %in
  store <9 x float> %tmp0, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v10f32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v10f32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    buffer_load_dwordx2 v[8:9], off, s[8:11], 0 offset:32
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx2 v[8:9], off, s[4:7], 0 offset:32
; SI-NOHSA-NEXT:    s_endpgm
;
; GCN-HSA-LABEL: global_load_v10f32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GCN-HSA-NEXT:    s_add_i32 s12, s12, s17
; GCN-HSA-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-HSA-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    s_add_u32 s4, s2, 32
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCN-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCN-HSA-NEXT:    s_add_u32 s2, s2, 16
; GCN-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v9, s5
; GCN-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCN-HSA-NEXT:    v_mov_b32_e32 v8, s4
; GCN-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCN-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCN-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCN-HSA-NEXT:    flat_load_dwordx2 v[8:9], v[8:9]
; GCN-HSA-NEXT:    s_add_u32 s2, s0, 16
; GCN-HSA-NEXT:    v_mov_b32_e32 v11, s1
; GCN-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v10, s0
; GCN-HSA-NEXT:    s_add_u32 s0, s0, 32
; GCN-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v13, s3
; GCN-HSA-NEXT:    v_mov_b32_e32 v15, s1
; GCN-HSA-NEXT:    v_mov_b32_e32 v12, s2
; GCN-HSA-NEXT:    v_mov_b32_e32 v14, s0
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    flat_store_dwordx4 v[10:11], v[0:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    flat_store_dwordx4 v[12:13], v[4:7]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    flat_store_dwordx2 v[14:15], v[8:9]
; GCN-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v10f32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx2 v[8:9], off, s[8:11], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx2 v[8:9], off, s[4:7], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_endpgm
entry:
  %tmp0 = load <10 x float>, ptr addrspace(1) %in
  store <10 x float> %tmp0, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v11f32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v11f32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:32
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(0)
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[3:6], off, s[8:11], 0
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[7:10], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    buffer_store_dword v2, off, s[4:7], 0 offset:40
; SI-NOHSA-NEXT:    buffer_store_dwordx2 v[0:1], off, s[4:7], 0 offset:32
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[3:6], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[7:10], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    s_endpgm
;
; GCN-HSA-LABEL: global_load_v11f32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GCN-HSA-NEXT:    s_add_i32 s12, s12, s17
; GCN-HSA-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-HSA-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    s_add_u32 s4, s2, 32
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCN-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCN-HSA-NEXT:    s_add_u32 s2, s2, 16
; GCN-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v9, s5
; GCN-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCN-HSA-NEXT:    v_mov_b32_e32 v8, s4
; GCN-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCN-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCN-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCN-HSA-NEXT:    flat_load_dwordx3 v[8:10], v[8:9]
; GCN-HSA-NEXT:    s_add_u32 s2, s0, 16
; GCN-HSA-NEXT:    v_mov_b32_e32 v12, s1
; GCN-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v11, s0
; GCN-HSA-NEXT:    s_add_u32 s0, s0, 32
; GCN-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v14, s3
; GCN-HSA-NEXT:    v_mov_b32_e32 v16, s1
; GCN-HSA-NEXT:    v_mov_b32_e32 v13, s2
; GCN-HSA-NEXT:    v_mov_b32_e32 v15, s0
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    flat_store_dwordx4 v[11:12], v[0:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    flat_store_dwordx4 v[13:14], v[4:7]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    flat_store_dwordx3 v[15:16], v[8:10]
; GCN-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v11f32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx3 v[8:10], off, s[8:11], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx3 v[8:10], off, s[4:7], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_endpgm
entry:
  %tmp0 = load <11 x float>, ptr addrspace(1) %in
  store <11 x float> %tmp0, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v12f32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v12f32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0 offset:32
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0 offset:32
; SI-NOHSA-NEXT:    s_endpgm
;
; GCN-HSA-LABEL: global_load_v12f32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GCN-HSA-NEXT:    s_add_i32 s12, s12, s17
; GCN-HSA-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-HSA-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    s_add_u32 s4, s2, 32
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCN-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCN-HSA-NEXT:    s_add_u32 s2, s2, 16
; GCN-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v9, s5
; GCN-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCN-HSA-NEXT:    v_mov_b32_e32 v8, s4
; GCN-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCN-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCN-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCN-HSA-NEXT:    flat_load_dwordx4 v[8:11], v[8:9]
; GCN-HSA-NEXT:    s_add_u32 s2, s0, 16
; GCN-HSA-NEXT:    v_mov_b32_e32 v13, s1
; GCN-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v12, s0
; GCN-HSA-NEXT:    s_add_u32 s0, s0, 32
; GCN-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v15, s3
; GCN-HSA-NEXT:    v_mov_b32_e32 v17, s1
; GCN-HSA-NEXT:    v_mov_b32_e32 v14, s2
; GCN-HSA-NEXT:    v_mov_b32_e32 v16, s0
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    flat_store_dwordx4 v[12:13], v[0:3]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    flat_store_dwordx4 v[14:15], v[4:7]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    flat_store_dwordx4 v[16:17], v[8:11]
; GCN-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v12f32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(2)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_endpgm
entry:
  %tmp0 = load <12 x float>, ptr addrspace(1) %in
  store <12 x float> %tmp0, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @global_load_v16f32(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; SI-NOHSA-LABEL: global_load_v16f32:
; SI-NOHSA:       ; %bb.0: ; %entry
; SI-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x9
; SI-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; SI-NOHSA-NEXT:    s_mov_b32 s6, -1
; SI-NOHSA-NEXT:    s_mov_b32 s10, s6
; SI-NOHSA-NEXT:    s_mov_b32 s11, s7
; SI-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; SI-NOHSA-NEXT:    s_mov_b32 s4, s0
; SI-NOHSA-NEXT:    s_mov_b32 s5, s1
; SI-NOHSA-NEXT:    s_mov_b32 s8, s2
; SI-NOHSA-NEXT:    s_mov_b32 s9, s3
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:32
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:48
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0
; SI-NOHSA-NEXT:    buffer_load_dwordx4 v[12:15], off, s[8:11], 0 offset:16
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0 offset:32
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:48
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0
; SI-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; SI-NOHSA-NEXT:    buffer_store_dwordx4 v[12:15], off, s[4:7], 0 offset:16
; SI-NOHSA-NEXT:    s_endpgm
;
; GCN-HSA-LABEL: global_load_v16f32:
; GCN-HSA:       ; %bb.0: ; %entry
; GCN-HSA-NEXT:    s_load_dwordx4 s[0:3], s[8:9], 0x0
; GCN-HSA-NEXT:    s_add_i32 s12, s12, s17
; GCN-HSA-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GCN-HSA-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GCN-HSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-HSA-NEXT:    s_add_u32 s4, s2, 16
; GCN-HSA-NEXT:    s_addc_u32 s5, s3, 0
; GCN-HSA-NEXT:    s_add_u32 s6, s2, 48
; GCN-HSA-NEXT:    v_mov_b32_e32 v9, s3
; GCN-HSA-NEXT:    s_addc_u32 s7, s3, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v8, s2
; GCN-HSA-NEXT:    s_add_u32 s2, s2, 32
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, s6
; GCN-HSA-NEXT:    s_addc_u32 s3, s3, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, s7
; GCN-HSA-NEXT:    v_mov_b32_e32 v5, s3
; GCN-HSA-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; GCN-HSA-NEXT:    v_mov_b32_e32 v4, s2
; GCN-HSA-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; GCN-HSA-NEXT:    flat_load_dwordx4 v[8:11], v[8:9]
; GCN-HSA-NEXT:    v_mov_b32_e32 v13, s5
; GCN-HSA-NEXT:    v_mov_b32_e32 v12, s4
; GCN-HSA-NEXT:    flat_load_dwordx4 v[12:15], v[12:13]
; GCN-HSA-NEXT:    s_add_u32 s2, s0, 32
; GCN-HSA-NEXT:    s_addc_u32 s3, s1, 0
; GCN-HSA-NEXT:    s_add_u32 s4, s0, 48
; GCN-HSA-NEXT:    v_mov_b32_e32 v17, s1
; GCN-HSA-NEXT:    s_addc_u32 s5, s1, 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v16, s0
; GCN-HSA-NEXT:    v_mov_b32_e32 v19, s5
; GCN-HSA-NEXT:    s_add_u32 s0, s0, 16
; GCN-HSA-NEXT:    v_mov_b32_e32 v18, s4
; GCN-HSA-NEXT:    s_addc_u32 s1, s1, 0
; GCN-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCN-HSA-NEXT:    flat_store_dwordx4 v[18:19], v[0:3]
; GCN-HSA-NEXT:    s_nop 0
; GCN-HSA-NEXT:    v_mov_b32_e32 v0, s2
; GCN-HSA-NEXT:    v_mov_b32_e32 v3, s1
; GCN-HSA-NEXT:    v_mov_b32_e32 v1, s3
; GCN-HSA-NEXT:    v_mov_b32_e32 v2, s0
; GCN-HSA-NEXT:    s_waitcnt vmcnt(2)
; GCN-HSA-NEXT:    flat_store_dwordx4 v[16:17], v[8:11]
; GCN-HSA-NEXT:    flat_store_dwordx4 v[0:1], v[4:7]
; GCN-HSA-NEXT:    s_waitcnt vmcnt(3)
; GCN-HSA-NEXT:    flat_store_dwordx4 v[2:3], v[12:15]
; GCN-HSA-NEXT:    s_endpgm
;
; GCNX3-NOHSA-LABEL: global_load_v16f32:
; GCNX3-NOHSA:       ; %bb.0: ; %entry
; GCNX3-NOHSA-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCNX3-NOHSA-NEXT:    s_mov_b32 s7, 0xf000
; GCNX3-NOHSA-NEXT:    s_mov_b32 s6, -1
; GCNX3-NOHSA-NEXT:    s_mov_b32 s10, s6
; GCNX3-NOHSA-NEXT:    s_mov_b32 s11, s7
; GCNX3-NOHSA-NEXT:    s_waitcnt lgkmcnt(0)
; GCNX3-NOHSA-NEXT:    s_mov_b32 s8, s2
; GCNX3-NOHSA-NEXT:    s_mov_b32 s9, s3
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[0:3], off, s[8:11], 0 offset:32
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[4:7], off, s[8:11], 0 offset:48
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[8:11], off, s[8:11], 0
; GCNX3-NOHSA-NEXT:    buffer_load_dwordx4 v[12:15], off, s[8:11], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_mov_b32 s4, s0
; GCNX3-NOHSA-NEXT:    s_mov_b32 s5, s1
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[0:3], off, s[4:7], 0 offset:32
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[4:7], off, s[4:7], 0 offset:48
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[8:11], off, s[4:7], 0
; GCNX3-NOHSA-NEXT:    s_waitcnt vmcnt(3)
; GCNX3-NOHSA-NEXT:    buffer_store_dwordx4 v[12:15], off, s[4:7], 0 offset:16
; GCNX3-NOHSA-NEXT:    s_endpgm
entry:
  %tmp0 = load <16 x float>, ptr addrspace(1) %in
  store <16 x float> %tmp0, ptr addrspace(1) %out
  ret void
}

attributes #0 = { nounwind }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; FUNC: {{.*}}
; GCN-NOHSA: {{.*}}
; GCNX3-HSA: {{.*}}
; R600: {{.*}}
