; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes=newgvn -S < %s | FileCheck %s

target datalayout = "e-p:64:64:64"

; GVN should ignore the store to p[1] to see that the load from p[0] is
; fully redundant.

define void @yes(i1 %c, ptr %p, ptr %q) nounwind {
; CHECK-LABEL: define void @yes
; CHECK-SAME: (i1 [[C:%.*]], ptr [[P:%.*]], ptr [[Q:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i32 0, ptr [[P]], align 4
; CHECK-NEXT:    [[P1:%.*]] = getelementptr inbounds i32, ptr [[P]], i64 1
; CHECK-NEXT:    store i32 1, ptr [[P1]], align 4
; CHECK-NEXT:    br i1 [[C]], label [[IF_ELSE:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    store i32 0, ptr [[Q]], align 4
; CHECK-NEXT:    ret void
; CHECK:       if.else:
; CHECK-NEXT:    ret void
;
entry:
  store i32 0, ptr %p
  %p1 = getelementptr inbounds i32, ptr %p, i64 1
  store i32 1, ptr %p1
  br i1 %c, label %if.else, label %if.then

if.then:
  %t = load i32, ptr %p
  store i32 %t, ptr %q
  ret void

if.else:
  ret void
}

; GVN should ignore the store to p[1] to see that the first load from p[0] is
; fully redundant. However, the second load is larger, so it's not a simple
; redundancy.

define void @watch_out_for_size_change(i1 %c, ptr %p, ptr %q) nounwind {
; CHECK-LABEL: define void @watch_out_for_size_change
; CHECK-SAME: (i1 [[C:%.*]], ptr [[P:%.*]], ptr [[Q:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store i32 0, ptr [[P]], align 4
; CHECK-NEXT:    [[P1:%.*]] = getelementptr inbounds i32, ptr [[P]], i64 1
; CHECK-NEXT:    store i32 1, ptr [[P1]], align 4
; CHECK-NEXT:    br i1 [[C]], label [[IF_ELSE:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    store i32 0, ptr [[Q]], align 4
; CHECK-NEXT:    ret void
; CHECK:       if.else:
; CHECK-NEXT:    [[T64:%.*]] = load i64, ptr [[P]], align 4
; CHECK-NEXT:    store i64 [[T64]], ptr [[Q]], align 4
; CHECK-NEXT:    ret void
;
entry:
  store i32 0, ptr %p
  %p1 = getelementptr inbounds i32, ptr %p, i64 1
  store i32 1, ptr %p1
  br i1 %c, label %if.else, label %if.then

if.then:
  %t = load i32, ptr %p
  store i32 %t, ptr %q
  ret void

if.else:
  %t64 = load i64, ptr %p
  store i64 %t64, ptr %q
  ret void
}
