; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

; Test constant fold of constant expression GEP used by ptrtoint (the
; "offsetof-like expression" case).
; This used to hit an assert due to not supporting vectors in
; llvm::ConstantFoldCastInstruction when handling ptrtoint.
define <2 x i16> @test1() null_pointer_is_valid {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret <2 x i16> <i16 ptrtoint (ptr getelementptr inbounds ([10 x i32], ptr null, i64 0, i64 5) to i16), i16 ptrtoint (ptr getelementptr inbounds ([10 x i32], ptr null, i64 0, i64 7) to i16)>
;
entry:
  %gep = getelementptr inbounds [10 x i32], ptr null, i16 0, <2 x i16> <i16 5, i16 7>
  %vec = ptrtoint <2 x ptr> %gep to <2 x i16>
  ret <2 x i16> %vec
}

; Test constant fold of constant expression GEP used by ptrtoint (the
; "sizeof-like expression" case).
; This used to hit an assert due to not supporting vectors in
; llvm::ConstantFoldCastInstruction when handling ptrtoint.
define <2 x i16> @test2() null_pointer_is_valid {
; CHECK-LABEL: @test2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    ret <2 x i16> <i16 ptrtoint (ptr getelementptr (i32, ptr null, i64 5) to i16), i16 ptrtoint (ptr getelementptr (i32, ptr null, i64 7) to i16)>
;
entry:
  %gep = getelementptr i32, ptr null, <2 x i16> <i16 5, i16 7>
  %vec = ptrtoint <2 x ptr> %gep to <2 x i16>
  ret <2 x i16> %vec
}
