// RUN: llvm-mc -triple=amdgcn -mcpu=gfx950 -show-encoding %s | FileCheck %s

// CHECK: encoding: [0x01,0x05,0x0a,0x2c]
v_dot2c_f32_bf16 v5, v1, v2

// CHECK: encoding: [0x01,0x05,0xfe,0x2d]
v_dot2c_f32_bf16 v255, v1, v2

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0xfe,0x2d,0x01,0xe4,0x00,0x00]
v_dot2c_f32_bf16_dpp v255, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0xff,0xe4,0x00,0x00]
v_dot2c_f32_bf16_dpp v5, v255, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0xfe,0x0b,0x2c,0x01,0xe4,0x00,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v255 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x1b,0x00,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 quad_perm:[3,2,1,0] row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x40,0x01,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 row_mirror row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x41,0x01,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 row_half_mirror row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x42,0x01,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 row_bcast:15 row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x43,0x01,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 row_bcast:31 row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x30,0x01,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 wave_shl:1 row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x34,0x01,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 wave_rol:1 row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x38,0x01,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 wave_shr:1 row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x3c,0x01,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 wave_ror:1 row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x01,0x01,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 row_shl:1 row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x0f,0x01,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 row_shl:15 row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x11,0x01,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 row_shr:1 row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x1f,0x01,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 row_shr:15 row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x21,0x01,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 row_ror:1 row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0x2f,0x01,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 row_ror:15 row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x10]
v_dot2c_f32_bf16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x1 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x30]
v_dot2c_f32_bf16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x3 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0xf0]
v_dot2c_f32_bf16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0xf0]
v_dot2c_f32_bf16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x01]
v_dot2c_f32_bf16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x1

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x03]
v_dot2c_f32_bf16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x3

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x0f]
v_dot2c_f32_bf16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x00,0x0f]
v_dot2c_f32_bf16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0xf

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x08,0x00]
v_dot2c_f32_bf16_dpp v5, v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0 bound_ctrl:1

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x10,0x00]
v_dot2c_f32_bf16_dpp v5, -v1, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x20,0x00]
v_dot2c_f32_bf16_dpp v5, |v1|, v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x40,0x00]
v_dot2c_f32_bf16_dpp v5, v1, -v2 quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0xfa,0x04,0x0a,0x2c,0x01,0xe4,0x80,0x00]
v_dot2c_f32_bf16_dpp v5, v1, |v2| quad_perm:[0,1,2,3] row_mask:0x0 bank_mask:0x0

// CHECK: encoding: [0x05,0x00,0x16,0xd1,0x01,0xfb,0x01,0x00]
v_dot2c_f32_bf16_e64 v5, v1, src_scc

// CHECK: encoding: [0x05,0x00,0x16,0xd1,0xff,0xf9,0x01,0x00]
v_dot2c_f32_bf16_e64 v5, v255, src_execz

// CHECK: encoding: [0x05,0x00,0x16,0xd1,0x65,0xca,0x00,0x00]
v_dot2c_f32_bf16_e64 v5, s101, s101

// CHECK: encoding: [0x05,0x00,0x16,0xd1,0xc1,0xcc,0x00,0x00]
v_dot2c_f32_bf16_e64 v5, -1, flat_scratch_lo

// CHECK: encoding: [0x05,0x02,0x16,0xd1,0xf0,0xce,0x00,0x40]
v_dot2c_f32_bf16_e64 v5, 0.5, -|flat_scratch_hi|

// CHECK: encoding: [0x05,0x00,0x16,0xd1,0xfc,0xe0,0x01,0x10]
v_dot2c_f32_bf16_e64 v5, src_execz, 0.5 mul:4

// CHECK: encoding: [0xff,0x81,0x16,0xd1,0xfd,0x82,0x01,0x38]
v_dot2c_f32_bf16_e64 v255, -|src_scc|, -1 clamp div:2

// CHECK: encoding: [0x8a,0x04,0x0a,0x2c]
v_dot2c_f32_bf16_e32 v5, 10, v2         ; encoding: [0x8a,0x04,0x0a,0x2c]

// CHECK: encoding: [0xff,0x04,0x0a,0x2c,0x64,0x00,0x00,0x00]
v_dot2c_f32_bf16_e32 v5, 100, v2       ; encoding: [0xff,0x04,0x0a,0x2c,0x64,0x00,0x00,0x00]

// CHECK: encoding: [0xff,0x04,0x0a,0x2c,0x22,0x41,0x00,0x00]
v_dot2c_f32_bf16_e32 v5, 10.1, v2     ; encoding: [0xff,0x04,0x0a,0x2c,0x22,0x41,0x00,0x00]
