; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=RV32
; RUN: llc -mtriple=riscv32 -mattr=+xtheadcondmov -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=RV32-THEAD
; RUN: llc -mtriple=riscv32 -mattr=+experimental-xqcicm -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=RV32-XQCICM
; RUN: llc -mtriple=riscv32 -mattr=+experimental-xqcics -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=RV32-XQCICS
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=RV64
; RUN: llc -mtriple=riscv64 -mattr=+xmipscmov -verify-machineinstrs < %s \
; RUN:   | FileCheck %s --check-prefixes=RV64-MIPS

define signext i32 @select_i32_trunc(i32 signext %cond, i32 signext %x, i32 signext %y) nounwind {
; RV32-LABEL: select_i32_trunc:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a3, a0, 1
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    bnez a3, .LBB0_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:  .LBB0_2:
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i32_trunc:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    andi a0, a0, 1
; RV32-THEAD-NEXT:    th.mveqz a1, a2, a0
; RV32-THEAD-NEXT:    mv a0, a1
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i32_trunc:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    andi a0, a0, 1
; RV32-XQCICM-NEXT:    qc.mveqi a1, a0, 0, a2
; RV32-XQCICM-NEXT:    mv a0, a1
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i32_trunc:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    andi a0, a0, 1
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a1, a2
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i32_trunc:
; RV64:       # %bb.0:
; RV64-NEXT:    andi a3, a0, 1
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB0_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB0_2:
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i32_trunc:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    andi a0, a0, 1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a1, a2
; RV64-MIPS-NEXT:    ret
  %cond_trunc = trunc i32 %cond to i1
  %res = select i1 %cond_trunc, i32 %x, i32 %y
  ret i32 %res
}

define signext i32 @select_i32_param(i1 signext %cond, i32 signext %x, i32 signext %y) nounwind {
; RV32-LABEL: select_i32_param:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a3, a0, 1
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    bnez a3, .LBB1_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:  .LBB1_2:
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i32_param:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    andi a0, a0, 1
; RV32-THEAD-NEXT:    th.mveqz a1, a2, a0
; RV32-THEAD-NEXT:    mv a0, a1
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i32_param:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    andi a0, a0, 1
; RV32-XQCICM-NEXT:    qc.mveqi a1, a0, 0, a2
; RV32-XQCICM-NEXT:    mv a0, a1
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i32_param:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    andi a0, a0, 1
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a1, a2
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i32_param:
; RV64:       # %bb.0:
; RV64-NEXT:    andi a3, a0, 1
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB1_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB1_2:
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i32_param:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    andi a0, a0, 1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a1, a2
; RV64-MIPS-NEXT:    ret
  %res = select i1 %cond, i32 %x, i32 %y
  ret i32 %res
}

define signext i32 @select_i32_eq(i32 signext %a, i32 signext %b, i32 signext %x, i32 signext %y) nounwind {
; RV32-LABEL: select_i32_eq:
; RV32:       # %bb.0:
; RV32-NEXT:    beq a0, a1, .LBB2_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a2, a3
; RV32-NEXT:  .LBB2_2:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i32_eq:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    xor a0, a0, a1
; RV32-THEAD-NEXT:    th.mvnez a2, a3, a0
; RV32-THEAD-NEXT:    mv a0, a2
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i32_eq:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    qc.mveq a3, a0, a1, a2
; RV32-XQCICM-NEXT:    mv a0, a3
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i32_eq:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    xor a0, a0, a1
; RV32-XQCICS-NEXT:    seqz a0, a0
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a2, a3
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i32_eq:
; RV64:       # %bb.0:
; RV64-NEXT:    beq a0, a1, .LBB2_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB2_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i32_eq:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    xor a0, a0, a1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a3, a2
; RV64-MIPS-NEXT:    ret
  %cond = icmp eq i32 %a, %b
  %res = select i1 %cond, i32 %x, i32 %y
  ret i32 %res
}

define signext i32 @select_i32_ne(i32 signext %a, i32 signext %b, i32 signext %x, i32 signext %y) nounwind {
; RV32-LABEL: select_i32_ne:
; RV32:       # %bb.0:
; RV32-NEXT:    bne a0, a1, .LBB3_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a2, a3
; RV32-NEXT:  .LBB3_2:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i32_ne:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    xor a0, a0, a1
; RV32-THEAD-NEXT:    th.mveqz a2, a3, a0
; RV32-THEAD-NEXT:    mv a0, a2
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i32_ne:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    qc.mvne a3, a0, a1, a2
; RV32-XQCICM-NEXT:    mv a0, a3
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i32_ne:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    xor a0, a0, a1
; RV32-XQCICS-NEXT:    snez a0, a0
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a2, a3
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i32_ne:
; RV64:       # %bb.0:
; RV64-NEXT:    bne a0, a1, .LBB3_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB3_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i32_ne:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    xor a0, a0, a1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a2, a3
; RV64-MIPS-NEXT:    ret
  %cond = icmp ne i32 %a, %b
  %res = select i1 %cond, i32 %x, i32 %y
  ret i32 %res
}

define signext i32 @select_i32_ugt(i32 signext %a, i32 signext %b, i32 signext %x, i32 signext %y) nounwind {
; RV32-LABEL: select_i32_ugt:
; RV32:       # %bb.0:
; RV32-NEXT:    bltu a1, a0, .LBB4_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a2, a3
; RV32-NEXT:  .LBB4_2:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i32_ugt:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    sltu a0, a1, a0
; RV32-THEAD-NEXT:    th.mveqz a2, a3, a0
; RV32-THEAD-NEXT:    mv a0, a2
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i32_ugt:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    qc.mvltu a3, a1, a0, a2
; RV32-XQCICM-NEXT:    mv a0, a3
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i32_ugt:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    sltu a0, a1, a0
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a2, a3
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i32_ugt:
; RV64:       # %bb.0:
; RV64-NEXT:    bltu a1, a0, .LBB4_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB4_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i32_ugt:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    sltu a0, a1, a0
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a2, a3
; RV64-MIPS-NEXT:    ret
  %cond = icmp ugt i32 %a, %b
  %res = select i1 %cond, i32 %x, i32 %y
  ret i32 %res
}

define signext i32 @select_i32_uge(i32 signext %a, i32 signext %b, i32 signext %x, i32 signext %y) nounwind {
; RV32-LABEL: select_i32_uge:
; RV32:       # %bb.0:
; RV32-NEXT:    bgeu a0, a1, .LBB5_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a2, a3
; RV32-NEXT:  .LBB5_2:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i32_uge:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    sltu a0, a0, a1
; RV32-THEAD-NEXT:    th.mvnez a2, a3, a0
; RV32-THEAD-NEXT:    mv a0, a2
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i32_uge:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    qc.mvltu a2, a0, a1, a3
; RV32-XQCICM-NEXT:    mv a0, a2
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i32_uge:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    sltu a0, a0, a1
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a3, a2
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i32_uge:
; RV64:       # %bb.0:
; RV64-NEXT:    bgeu a0, a1, .LBB5_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB5_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i32_uge:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    sltu a0, a0, a1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a3, a2
; RV64-MIPS-NEXT:    ret
  %cond = icmp uge i32 %a, %b
  %res = select i1 %cond, i32 %x, i32 %y
  ret i32 %res
}

define signext i32 @select_i32_ult(i32 signext %a, i32 signext %b, i32 signext %x, i32 signext %y) nounwind {
; RV32-LABEL: select_i32_ult:
; RV32:       # %bb.0:
; RV32-NEXT:    bltu a0, a1, .LBB6_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a2, a3
; RV32-NEXT:  .LBB6_2:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i32_ult:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    sltu a0, a0, a1
; RV32-THEAD-NEXT:    th.mveqz a2, a3, a0
; RV32-THEAD-NEXT:    mv a0, a2
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i32_ult:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    qc.mvltu a3, a0, a1, a2
; RV32-XQCICM-NEXT:    mv a0, a3
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i32_ult:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    sltu a0, a0, a1
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a2, a3
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i32_ult:
; RV64:       # %bb.0:
; RV64-NEXT:    bltu a0, a1, .LBB6_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB6_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i32_ult:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    sltu a0, a0, a1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a2, a3
; RV64-MIPS-NEXT:    ret
  %cond = icmp ult i32 %a, %b
  %res = select i1 %cond, i32 %x, i32 %y
  ret i32 %res
}

define signext i32 @select_i32_ule(i32 signext %a, i32 signext %b, i32 signext %x, i32 signext %y) nounwind {
; RV32-LABEL: select_i32_ule:
; RV32:       # %bb.0:
; RV32-NEXT:    bgeu a1, a0, .LBB7_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a2, a3
; RV32-NEXT:  .LBB7_2:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i32_ule:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    sltu a0, a1, a0
; RV32-THEAD-NEXT:    th.mvnez a2, a3, a0
; RV32-THEAD-NEXT:    mv a0, a2
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i32_ule:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    qc.mvltu a2, a1, a0, a3
; RV32-XQCICM-NEXT:    mv a0, a2
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i32_ule:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    sltu a0, a1, a0
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a3, a2
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i32_ule:
; RV64:       # %bb.0:
; RV64-NEXT:    bgeu a1, a0, .LBB7_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB7_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i32_ule:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    sltu a0, a1, a0
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a3, a2
; RV64-MIPS-NEXT:    ret
  %cond = icmp ule i32 %a, %b
  %res = select i1 %cond, i32 %x, i32 %y
  ret i32 %res
}

define signext i32 @select_i32_sgt(i32 signext %a, i32 signext %b, i32 signext %x, i32 signext %y) nounwind {
; RV32-LABEL: select_i32_sgt:
; RV32:       # %bb.0:
; RV32-NEXT:    blt a1, a0, .LBB8_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a2, a3
; RV32-NEXT:  .LBB8_2:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i32_sgt:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    slt a0, a1, a0
; RV32-THEAD-NEXT:    th.mveqz a2, a3, a0
; RV32-THEAD-NEXT:    mv a0, a2
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i32_sgt:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    qc.mvlt a3, a1, a0, a2
; RV32-XQCICM-NEXT:    mv a0, a3
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i32_sgt:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    slt a0, a1, a0
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a2, a3
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i32_sgt:
; RV64:       # %bb.0:
; RV64-NEXT:    blt a1, a0, .LBB8_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB8_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i32_sgt:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    slt a0, a1, a0
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a2, a3
; RV64-MIPS-NEXT:    ret
  %cond = icmp sgt i32 %a, %b
  %res = select i1 %cond, i32 %x, i32 %y
  ret i32 %res
}

define signext i32 @select_i32_sge(i32 signext %a, i32 signext %b, i32 signext %x, i32 signext %y) nounwind {
; RV32-LABEL: select_i32_sge:
; RV32:       # %bb.0:
; RV32-NEXT:    bge a0, a1, .LBB9_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a2, a3
; RV32-NEXT:  .LBB9_2:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i32_sge:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    slt a0, a0, a1
; RV32-THEAD-NEXT:    th.mvnez a2, a3, a0
; RV32-THEAD-NEXT:    mv a0, a2
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i32_sge:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    qc.mvlt a2, a0, a1, a3
; RV32-XQCICM-NEXT:    mv a0, a2
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i32_sge:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    slt a0, a0, a1
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a3, a2
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i32_sge:
; RV64:       # %bb.0:
; RV64-NEXT:    bge a0, a1, .LBB9_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB9_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i32_sge:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    slt a0, a0, a1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a3, a2
; RV64-MIPS-NEXT:    ret
  %cond = icmp sge i32 %a, %b
  %res = select i1 %cond, i32 %x, i32 %y
  ret i32 %res
}

define signext i32 @select_i32_slt(i32 signext %a, i32 signext %b, i32 signext %x, i32 signext %y) nounwind {
; RV32-LABEL: select_i32_slt:
; RV32:       # %bb.0:
; RV32-NEXT:    blt a0, a1, .LBB10_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a2, a3
; RV32-NEXT:  .LBB10_2:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i32_slt:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    slt a0, a0, a1
; RV32-THEAD-NEXT:    th.mveqz a2, a3, a0
; RV32-THEAD-NEXT:    mv a0, a2
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i32_slt:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    qc.mvlt a3, a0, a1, a2
; RV32-XQCICM-NEXT:    mv a0, a3
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i32_slt:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    slt a0, a0, a1
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a2, a3
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i32_slt:
; RV64:       # %bb.0:
; RV64-NEXT:    blt a0, a1, .LBB10_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB10_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i32_slt:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    slt a0, a0, a1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a2, a3
; RV64-MIPS-NEXT:    ret
  %cond = icmp slt i32 %a, %b
  %res = select i1 %cond, i32 %x, i32 %y
  ret i32 %res
}

define signext i32 @select_i32_sle(i32 signext %a, i32 signext %b, i32 signext %x, i32 signext %y) nounwind {
; RV32-LABEL: select_i32_sle:
; RV32:       # %bb.0:
; RV32-NEXT:    bge a1, a0, .LBB11_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a2, a3
; RV32-NEXT:  .LBB11_2:
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i32_sle:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    slt a0, a1, a0
; RV32-THEAD-NEXT:    th.mvnez a2, a3, a0
; RV32-THEAD-NEXT:    mv a0, a2
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i32_sle:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    qc.mvlt a2, a1, a0, a3
; RV32-XQCICM-NEXT:    mv a0, a2
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i32_sle:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    slt a0, a1, a0
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a3, a2
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i32_sle:
; RV64:       # %bb.0:
; RV64-NEXT:    bge a1, a0, .LBB11_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB11_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i32_sle:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    slt a0, a1, a0
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a3, a2
; RV64-MIPS-NEXT:    ret
  %cond = icmp sle i32 %a, %b
  %res = select i1 %cond, i32 %x, i32 %y
  ret i32 %res
}

define i64 @select_i64_trunc(i64 %cond, i64 %x, i64 %y) nounwind {
; RV32-LABEL: select_i64_trunc:
; RV32:       # %bb.0:
; RV32-NEXT:    mv a1, a3
; RV32-NEXT:    andi a3, a0, 1
; RV32-NEXT:    mv a0, a2
; RV32-NEXT:    bnez a3, .LBB12_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:  .LBB12_2:
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i64_trunc:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    mv a1, a3
; RV32-THEAD-NEXT:    andi a0, a0, 1
; RV32-THEAD-NEXT:    th.mveqz a2, a4, a0
; RV32-THEAD-NEXT:    th.mveqz a1, a5, a0
; RV32-THEAD-NEXT:    mv a0, a2
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i64_trunc:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    mv a1, a3
; RV32-XQCICM-NEXT:    andi a0, a0, 1
; RV32-XQCICM-NEXT:    qc.mveqi a2, a0, 0, a4
; RV32-XQCICM-NEXT:    qc.mveqi a1, a0, 0, a5
; RV32-XQCICM-NEXT:    mv a0, a2
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i64_trunc:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    andi a1, a0, 1
; RV32-XQCICS-NEXT:    mv a0, a1
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a3, a5
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a2, a4
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i64_trunc:
; RV64:       # %bb.0:
; RV64-NEXT:    andi a3, a0, 1
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB12_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB12_2:
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i64_trunc:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    andi a0, a0, 1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a1, a2
; RV64-MIPS-NEXT:    ret
  %cond_trunc = trunc i64 %cond to i1
  %res = select i1 %cond_trunc, i64 %x, i64 %y
  ret i64 %res
}

define i64 @select_i64_param(i1 %cond, i64 %x, i64 %y) nounwind {
; RV32-LABEL: select_i64_param:
; RV32:       # %bb.0:
; RV32-NEXT:    andi a5, a0, 1
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:    bnez a5, .LBB13_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a3
; RV32-NEXT:    mv a2, a4
; RV32-NEXT:  .LBB13_2:
; RV32-NEXT:    mv a1, a2
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i64_param:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    andi a0, a0, 1
; RV32-THEAD-NEXT:    th.mveqz a1, a3, a0
; RV32-THEAD-NEXT:    th.mveqz a2, a4, a0
; RV32-THEAD-NEXT:    mv a0, a1
; RV32-THEAD-NEXT:    mv a1, a2
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i64_param:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    andi a0, a0, 1
; RV32-XQCICM-NEXT:    qc.mveqi a1, a0, 0, a3
; RV32-XQCICM-NEXT:    qc.mveqi a2, a0, 0, a4
; RV32-XQCICM-NEXT:    mv a0, a1
; RV32-XQCICM-NEXT:    mv a1, a2
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i64_param:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    andi a5, a0, 1
; RV32-XQCICS-NEXT:    mv a0, a5
; RV32-XQCICS-NEXT:    qc.selectnei a5, 0, a2, a4
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a1, a3
; RV32-XQCICS-NEXT:    mv a1, a5
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i64_param:
; RV64:       # %bb.0:
; RV64-NEXT:    andi a3, a0, 1
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:    bnez a3, .LBB13_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:  .LBB13_2:
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i64_param:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    andi a0, a0, 1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a1, a2
; RV64-MIPS-NEXT:    ret
  %res = select i1 %cond, i64 %x, i64 %y
  ret i64 %res
}

define i64 @select_i64_eq(i64 %a, i64 %b, i64 %x, i64 %y) nounwind {
; RV32-LABEL: select_i64_eq:
; RV32:       # %bb.0:
; RV32-NEXT:    xor a1, a1, a3
; RV32-NEXT:    xor a0, a0, a2
; RV32-NEXT:    or a1, a0, a1
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    beqz a1, .LBB14_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a6
; RV32-NEXT:    mv a5, a7
; RV32-NEXT:  .LBB14_2:
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i64_eq:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    xor a1, a1, a3
; RV32-THEAD-NEXT:    xor a0, a0, a2
; RV32-THEAD-NEXT:    or a0, a0, a1
; RV32-THEAD-NEXT:    th.mvnez a4, a6, a0
; RV32-THEAD-NEXT:    th.mvnez a5, a7, a0
; RV32-THEAD-NEXT:    mv a0, a4
; RV32-THEAD-NEXT:    mv a1, a5
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i64_eq:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    xor a1, a1, a3
; RV32-XQCICM-NEXT:    xor a0, a0, a2
; RV32-XQCICM-NEXT:    or a0, a0, a1
; RV32-XQCICM-NEXT:    qc.mveqi a6, a0, 0, a4
; RV32-XQCICM-NEXT:    qc.mveqi a7, a0, 0, a5
; RV32-XQCICM-NEXT:    mv a0, a6
; RV32-XQCICM-NEXT:    mv a1, a7
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i64_eq:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    xor a1, a1, a3
; RV32-XQCICS-NEXT:    xor a0, a0, a2
; RV32-XQCICS-NEXT:    or a1, a0, a1
; RV32-XQCICS-NEXT:    mv a0, a1
; RV32-XQCICS-NEXT:    qc.selecteqi a0, 0, a4, a6
; RV32-XQCICS-NEXT:    qc.selecteqi a1, 0, a5, a7
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i64_eq:
; RV64:       # %bb.0:
; RV64-NEXT:    beq a0, a1, .LBB14_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB14_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i64_eq:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    xor a0, a0, a1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a3, a2
; RV64-MIPS-NEXT:    ret
  %cond = icmp eq i64 %a, %b
  %res = select i1 %cond, i64 %x, i64 %y
  ret i64 %res
}

define i64 @select_i64_ne(i64 %a, i64 %b, i64 %x, i64 %y) nounwind {
; RV32-LABEL: select_i64_ne:
; RV32:       # %bb.0:
; RV32-NEXT:    xor a1, a1, a3
; RV32-NEXT:    xor a0, a0, a2
; RV32-NEXT:    or a1, a0, a1
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    bnez a1, .LBB15_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a6
; RV32-NEXT:    mv a5, a7
; RV32-NEXT:  .LBB15_2:
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i64_ne:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    xor a1, a1, a3
; RV32-THEAD-NEXT:    xor a0, a0, a2
; RV32-THEAD-NEXT:    or a0, a0, a1
; RV32-THEAD-NEXT:    th.mveqz a4, a6, a0
; RV32-THEAD-NEXT:    th.mveqz a5, a7, a0
; RV32-THEAD-NEXT:    mv a0, a4
; RV32-THEAD-NEXT:    mv a1, a5
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i64_ne:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    xor a1, a1, a3
; RV32-XQCICM-NEXT:    xor a0, a0, a2
; RV32-XQCICM-NEXT:    or a0, a0, a1
; RV32-XQCICM-NEXT:    qc.mvnei a6, a0, 0, a4
; RV32-XQCICM-NEXT:    qc.mvnei a7, a0, 0, a5
; RV32-XQCICM-NEXT:    mv a0, a6
; RV32-XQCICM-NEXT:    mv a1, a7
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i64_ne:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    xor a1, a1, a3
; RV32-XQCICS-NEXT:    xor a0, a0, a2
; RV32-XQCICS-NEXT:    or a1, a0, a1
; RV32-XQCICS-NEXT:    mv a0, a1
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a4, a6
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a5, a7
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i64_ne:
; RV64:       # %bb.0:
; RV64-NEXT:    bne a0, a1, .LBB15_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB15_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i64_ne:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    xor a0, a0, a1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a2, a3
; RV64-MIPS-NEXT:    ret
  %cond = icmp ne i64 %a, %b
  %res = select i1 %cond, i64 %x, i64 %y
  ret i64 %res
}

define i64 @select_i64_ugt(i64 %a, i64 %b, i64 %x, i64 %y) nounwind {
; RV32-LABEL: select_i64_ugt:
; RV32:       # %bb.0:
; RV32-NEXT:    beq a1, a3, .LBB16_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    sltu a0, a3, a1
; RV32-NEXT:    beqz a0, .LBB16_3
; RV32-NEXT:    j .LBB16_4
; RV32-NEXT:  .LBB16_2:
; RV32-NEXT:    sltu a0, a2, a0
; RV32-NEXT:    bnez a0, .LBB16_4
; RV32-NEXT:  .LBB16_3:
; RV32-NEXT:    mv a4, a6
; RV32-NEXT:    mv a5, a7
; RV32-NEXT:  .LBB16_4:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i64_ugt:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    xor t0, a1, a3
; RV32-THEAD-NEXT:    sltu a1, a3, a1
; RV32-THEAD-NEXT:    sltu a0, a2, a0
; RV32-THEAD-NEXT:    th.mvnez a0, a1, t0
; RV32-THEAD-NEXT:    th.mveqz a4, a6, a0
; RV32-THEAD-NEXT:    th.mveqz a5, a7, a0
; RV32-THEAD-NEXT:    mv a0, a4
; RV32-THEAD-NEXT:    mv a1, a5
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i64_ugt:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    sltu a0, a2, a0
; RV32-XQCICM-NEXT:    sltu a2, a3, a1
; RV32-XQCICM-NEXT:    qc.mveq a2, a1, a3, a0
; RV32-XQCICM-NEXT:    qc.mveqi a4, a2, 0, a6
; RV32-XQCICM-NEXT:    qc.mveqi a5, a2, 0, a7
; RV32-XQCICM-NEXT:    mv a0, a4
; RV32-XQCICM-NEXT:    mv a1, a5
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i64_ugt:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    sltu t0, a3, a1
; RV32-XQCICS-NEXT:    sltu a0, a2, a0
; RV32-XQCICS-NEXT:    xor a1, a1, a3
; RV32-XQCICS-NEXT:    seqz a1, a1
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a0, t0
; RV32-XQCICS-NEXT:    mv a0, a1
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a4, a6
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a5, a7
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i64_ugt:
; RV64:       # %bb.0:
; RV64-NEXT:    bltu a1, a0, .LBB16_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB16_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i64_ugt:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    sltu a0, a1, a0
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a2, a3
; RV64-MIPS-NEXT:    ret
  %cond = icmp ugt i64 %a, %b
  %res = select i1 %cond, i64 %x, i64 %y
  ret i64 %res
}

define i64 @select_i64_uge(i64 %a, i64 %b, i64 %x, i64 %y) nounwind {
; RV32-LABEL: select_i64_uge:
; RV32:       # %bb.0:
; RV32-NEXT:    beq a1, a3, .LBB17_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    sltu a0, a1, a3
; RV32-NEXT:    bnez a0, .LBB17_3
; RV32-NEXT:    j .LBB17_4
; RV32-NEXT:  .LBB17_2:
; RV32-NEXT:    sltu a0, a0, a2
; RV32-NEXT:    beqz a0, .LBB17_4
; RV32-NEXT:  .LBB17_3:
; RV32-NEXT:    mv a4, a6
; RV32-NEXT:    mv a5, a7
; RV32-NEXT:  .LBB17_4:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i64_uge:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    xor t0, a1, a3
; RV32-THEAD-NEXT:    sltu a1, a1, a3
; RV32-THEAD-NEXT:    sltu a0, a0, a2
; RV32-THEAD-NEXT:    th.mvnez a0, a1, t0
; RV32-THEAD-NEXT:    th.mvnez a4, a6, a0
; RV32-THEAD-NEXT:    th.mvnez a5, a7, a0
; RV32-THEAD-NEXT:    mv a0, a4
; RV32-THEAD-NEXT:    mv a1, a5
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i64_uge:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    sltu a0, a0, a2
; RV32-XQCICM-NEXT:    sltu a2, a1, a3
; RV32-XQCICM-NEXT:    qc.mveq a2, a1, a3, a0
; RV32-XQCICM-NEXT:    qc.mveqi a6, a2, 0, a4
; RV32-XQCICM-NEXT:    qc.mveqi a7, a2, 0, a5
; RV32-XQCICM-NEXT:    mv a0, a6
; RV32-XQCICM-NEXT:    mv a1, a7
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i64_uge:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    sltu t0, a1, a3
; RV32-XQCICS-NEXT:    sltu a0, a0, a2
; RV32-XQCICS-NEXT:    xor a1, a1, a3
; RV32-XQCICS-NEXT:    seqz a1, a1
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a0, t0
; RV32-XQCICS-NEXT:    mv a0, a1
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a6, a4
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a7, a5
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i64_uge:
; RV64:       # %bb.0:
; RV64-NEXT:    bgeu a0, a1, .LBB17_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB17_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i64_uge:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    sltu a0, a0, a1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a3, a2
; RV64-MIPS-NEXT:    ret
  %cond = icmp uge i64 %a, %b
  %res = select i1 %cond, i64 %x, i64 %y
  ret i64 %res
}

define i64 @select_i64_ult(i64 %a, i64 %b, i64 %x, i64 %y) nounwind {
; RV32-LABEL: select_i64_ult:
; RV32:       # %bb.0:
; RV32-NEXT:    beq a1, a3, .LBB18_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    sltu a0, a1, a3
; RV32-NEXT:    beqz a0, .LBB18_3
; RV32-NEXT:    j .LBB18_4
; RV32-NEXT:  .LBB18_2:
; RV32-NEXT:    sltu a0, a0, a2
; RV32-NEXT:    bnez a0, .LBB18_4
; RV32-NEXT:  .LBB18_3:
; RV32-NEXT:    mv a4, a6
; RV32-NEXT:    mv a5, a7
; RV32-NEXT:  .LBB18_4:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i64_ult:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    xor t0, a1, a3
; RV32-THEAD-NEXT:    sltu a1, a1, a3
; RV32-THEAD-NEXT:    sltu a0, a0, a2
; RV32-THEAD-NEXT:    th.mvnez a0, a1, t0
; RV32-THEAD-NEXT:    th.mveqz a4, a6, a0
; RV32-THEAD-NEXT:    th.mveqz a5, a7, a0
; RV32-THEAD-NEXT:    mv a0, a4
; RV32-THEAD-NEXT:    mv a1, a5
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i64_ult:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    sltu a0, a0, a2
; RV32-XQCICM-NEXT:    sltu a2, a1, a3
; RV32-XQCICM-NEXT:    qc.mveq a2, a1, a3, a0
; RV32-XQCICM-NEXT:    qc.mveqi a4, a2, 0, a6
; RV32-XQCICM-NEXT:    qc.mveqi a5, a2, 0, a7
; RV32-XQCICM-NEXT:    mv a0, a4
; RV32-XQCICM-NEXT:    mv a1, a5
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i64_ult:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    sltu t0, a1, a3
; RV32-XQCICS-NEXT:    sltu a0, a0, a2
; RV32-XQCICS-NEXT:    xor a1, a1, a3
; RV32-XQCICS-NEXT:    seqz a1, a1
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a0, t0
; RV32-XQCICS-NEXT:    mv a0, a1
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a4, a6
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a5, a7
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i64_ult:
; RV64:       # %bb.0:
; RV64-NEXT:    bltu a0, a1, .LBB18_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB18_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i64_ult:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    sltu a0, a0, a1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a2, a3
; RV64-MIPS-NEXT:    ret
  %cond = icmp ult i64 %a, %b
  %res = select i1 %cond, i64 %x, i64 %y
  ret i64 %res
}

define i64 @select_i64_ule(i64 %a, i64 %b, i64 %x, i64 %y) nounwind {
; RV32-LABEL: select_i64_ule:
; RV32:       # %bb.0:
; RV32-NEXT:    beq a1, a3, .LBB19_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    sltu a0, a3, a1
; RV32-NEXT:    bnez a0, .LBB19_3
; RV32-NEXT:    j .LBB19_4
; RV32-NEXT:  .LBB19_2:
; RV32-NEXT:    sltu a0, a2, a0
; RV32-NEXT:    beqz a0, .LBB19_4
; RV32-NEXT:  .LBB19_3:
; RV32-NEXT:    mv a4, a6
; RV32-NEXT:    mv a5, a7
; RV32-NEXT:  .LBB19_4:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i64_ule:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    xor t0, a1, a3
; RV32-THEAD-NEXT:    sltu a1, a3, a1
; RV32-THEAD-NEXT:    sltu a0, a2, a0
; RV32-THEAD-NEXT:    th.mvnez a0, a1, t0
; RV32-THEAD-NEXT:    th.mvnez a4, a6, a0
; RV32-THEAD-NEXT:    th.mvnez a5, a7, a0
; RV32-THEAD-NEXT:    mv a0, a4
; RV32-THEAD-NEXT:    mv a1, a5
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i64_ule:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    sltu a0, a2, a0
; RV32-XQCICM-NEXT:    sltu a2, a3, a1
; RV32-XQCICM-NEXT:    qc.mveq a2, a1, a3, a0
; RV32-XQCICM-NEXT:    qc.mveqi a6, a2, 0, a4
; RV32-XQCICM-NEXT:    qc.mveqi a7, a2, 0, a5
; RV32-XQCICM-NEXT:    mv a0, a6
; RV32-XQCICM-NEXT:    mv a1, a7
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i64_ule:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    sltu t0, a3, a1
; RV32-XQCICS-NEXT:    sltu a0, a2, a0
; RV32-XQCICS-NEXT:    xor a1, a1, a3
; RV32-XQCICS-NEXT:    seqz a1, a1
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a0, t0
; RV32-XQCICS-NEXT:    mv a0, a1
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a6, a4
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a7, a5
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i64_ule:
; RV64:       # %bb.0:
; RV64-NEXT:    bgeu a1, a0, .LBB19_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB19_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i64_ule:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    sltu a0, a1, a0
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a3, a2
; RV64-MIPS-NEXT:    ret
  %cond = icmp ule i64 %a, %b
  %res = select i1 %cond, i64 %x, i64 %y
  ret i64 %res
}

define i64 @select_i64_sgt(i64 %a, i64 %b, i64 %x, i64 %y) nounwind {
; RV32-LABEL: select_i64_sgt:
; RV32:       # %bb.0:
; RV32-NEXT:    beq a1, a3, .LBB20_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    slt a0, a3, a1
; RV32-NEXT:    beqz a0, .LBB20_3
; RV32-NEXT:    j .LBB20_4
; RV32-NEXT:  .LBB20_2:
; RV32-NEXT:    sltu a0, a2, a0
; RV32-NEXT:    bnez a0, .LBB20_4
; RV32-NEXT:  .LBB20_3:
; RV32-NEXT:    mv a4, a6
; RV32-NEXT:    mv a5, a7
; RV32-NEXT:  .LBB20_4:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i64_sgt:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    xor t0, a1, a3
; RV32-THEAD-NEXT:    slt a1, a3, a1
; RV32-THEAD-NEXT:    sltu a0, a2, a0
; RV32-THEAD-NEXT:    th.mvnez a0, a1, t0
; RV32-THEAD-NEXT:    th.mveqz a4, a6, a0
; RV32-THEAD-NEXT:    th.mveqz a5, a7, a0
; RV32-THEAD-NEXT:    mv a0, a4
; RV32-THEAD-NEXT:    mv a1, a5
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i64_sgt:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    sltu a0, a2, a0
; RV32-XQCICM-NEXT:    slt a2, a3, a1
; RV32-XQCICM-NEXT:    qc.mveq a2, a1, a3, a0
; RV32-XQCICM-NEXT:    qc.mveqi a4, a2, 0, a6
; RV32-XQCICM-NEXT:    qc.mveqi a5, a2, 0, a7
; RV32-XQCICM-NEXT:    mv a0, a4
; RV32-XQCICM-NEXT:    mv a1, a5
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i64_sgt:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    slt t0, a3, a1
; RV32-XQCICS-NEXT:    sltu a0, a2, a0
; RV32-XQCICS-NEXT:    xor a1, a1, a3
; RV32-XQCICS-NEXT:    seqz a1, a1
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a0, t0
; RV32-XQCICS-NEXT:    mv a0, a1
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a4, a6
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a5, a7
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i64_sgt:
; RV64:       # %bb.0:
; RV64-NEXT:    blt a1, a0, .LBB20_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB20_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i64_sgt:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    slt a0, a1, a0
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a2, a3
; RV64-MIPS-NEXT:    ret
  %cond = icmp sgt i64 %a, %b
  %res = select i1 %cond, i64 %x, i64 %y
  ret i64 %res
}

define i64 @select_i64_sge(i64 %a, i64 %b, i64 %x, i64 %y) nounwind {
; RV32-LABEL: select_i64_sge:
; RV32:       # %bb.0:
; RV32-NEXT:    beq a1, a3, .LBB21_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    slt a0, a1, a3
; RV32-NEXT:    bnez a0, .LBB21_3
; RV32-NEXT:    j .LBB21_4
; RV32-NEXT:  .LBB21_2:
; RV32-NEXT:    sltu a0, a0, a2
; RV32-NEXT:    beqz a0, .LBB21_4
; RV32-NEXT:  .LBB21_3:
; RV32-NEXT:    mv a4, a6
; RV32-NEXT:    mv a5, a7
; RV32-NEXT:  .LBB21_4:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i64_sge:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    xor t0, a1, a3
; RV32-THEAD-NEXT:    slt a1, a1, a3
; RV32-THEAD-NEXT:    sltu a0, a0, a2
; RV32-THEAD-NEXT:    th.mvnez a0, a1, t0
; RV32-THEAD-NEXT:    th.mvnez a4, a6, a0
; RV32-THEAD-NEXT:    th.mvnez a5, a7, a0
; RV32-THEAD-NEXT:    mv a0, a4
; RV32-THEAD-NEXT:    mv a1, a5
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i64_sge:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    sltu a0, a0, a2
; RV32-XQCICM-NEXT:    slt a2, a1, a3
; RV32-XQCICM-NEXT:    qc.mveq a2, a1, a3, a0
; RV32-XQCICM-NEXT:    qc.mveqi a6, a2, 0, a4
; RV32-XQCICM-NEXT:    qc.mveqi a7, a2, 0, a5
; RV32-XQCICM-NEXT:    mv a0, a6
; RV32-XQCICM-NEXT:    mv a1, a7
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i64_sge:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    slt t0, a1, a3
; RV32-XQCICS-NEXT:    sltu a0, a0, a2
; RV32-XQCICS-NEXT:    xor a1, a1, a3
; RV32-XQCICS-NEXT:    seqz a1, a1
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a0, t0
; RV32-XQCICS-NEXT:    mv a0, a1
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a6, a4
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a7, a5
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i64_sge:
; RV64:       # %bb.0:
; RV64-NEXT:    bge a0, a1, .LBB21_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB21_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i64_sge:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    slt a0, a0, a1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a3, a2
; RV64-MIPS-NEXT:    ret
  %cond = icmp sge i64 %a, %b
  %res = select i1 %cond, i64 %x, i64 %y
  ret i64 %res
}

define i64 @select_i64_slt(i64 %a, i64 %b, i64 %x, i64 %y) nounwind {
; RV32-LABEL: select_i64_slt:
; RV32:       # %bb.0:
; RV32-NEXT:    beq a1, a3, .LBB22_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    slt a0, a1, a3
; RV32-NEXT:    beqz a0, .LBB22_3
; RV32-NEXT:    j .LBB22_4
; RV32-NEXT:  .LBB22_2:
; RV32-NEXT:    sltu a0, a0, a2
; RV32-NEXT:    bnez a0, .LBB22_4
; RV32-NEXT:  .LBB22_3:
; RV32-NEXT:    mv a4, a6
; RV32-NEXT:    mv a5, a7
; RV32-NEXT:  .LBB22_4:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i64_slt:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    xor t0, a1, a3
; RV32-THEAD-NEXT:    slt a1, a1, a3
; RV32-THEAD-NEXT:    sltu a0, a0, a2
; RV32-THEAD-NEXT:    th.mvnez a0, a1, t0
; RV32-THEAD-NEXT:    th.mveqz a4, a6, a0
; RV32-THEAD-NEXT:    th.mveqz a5, a7, a0
; RV32-THEAD-NEXT:    mv a0, a4
; RV32-THEAD-NEXT:    mv a1, a5
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i64_slt:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    sltu a0, a0, a2
; RV32-XQCICM-NEXT:    slt a2, a1, a3
; RV32-XQCICM-NEXT:    qc.mveq a2, a1, a3, a0
; RV32-XQCICM-NEXT:    qc.mveqi a4, a2, 0, a6
; RV32-XQCICM-NEXT:    qc.mveqi a5, a2, 0, a7
; RV32-XQCICM-NEXT:    mv a0, a4
; RV32-XQCICM-NEXT:    mv a1, a5
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i64_slt:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    slt t0, a1, a3
; RV32-XQCICS-NEXT:    sltu a0, a0, a2
; RV32-XQCICS-NEXT:    xor a1, a1, a3
; RV32-XQCICS-NEXT:    seqz a1, a1
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a0, t0
; RV32-XQCICS-NEXT:    mv a0, a1
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a4, a6
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a5, a7
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i64_slt:
; RV64:       # %bb.0:
; RV64-NEXT:    blt a0, a1, .LBB22_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB22_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i64_slt:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    slt a0, a0, a1
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a2, a3
; RV64-MIPS-NEXT:    ret
  %cond = icmp slt i64 %a, %b
  %res = select i1 %cond, i64 %x, i64 %y
  ret i64 %res
}

define i64 @select_i64_sle(i64 %a, i64 %b, i64 %x, i64 %y) nounwind {
; RV32-LABEL: select_i64_sle:
; RV32:       # %bb.0:
; RV32-NEXT:    beq a1, a3, .LBB23_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    slt a0, a3, a1
; RV32-NEXT:    bnez a0, .LBB23_3
; RV32-NEXT:    j .LBB23_4
; RV32-NEXT:  .LBB23_2:
; RV32-NEXT:    sltu a0, a2, a0
; RV32-NEXT:    beqz a0, .LBB23_4
; RV32-NEXT:  .LBB23_3:
; RV32-NEXT:    mv a4, a6
; RV32-NEXT:    mv a5, a7
; RV32-NEXT:  .LBB23_4:
; RV32-NEXT:    mv a0, a4
; RV32-NEXT:    mv a1, a5
; RV32-NEXT:    ret
;
; RV32-THEAD-LABEL: select_i64_sle:
; RV32-THEAD:       # %bb.0:
; RV32-THEAD-NEXT:    xor t0, a1, a3
; RV32-THEAD-NEXT:    slt a1, a3, a1
; RV32-THEAD-NEXT:    sltu a0, a2, a0
; RV32-THEAD-NEXT:    th.mvnez a0, a1, t0
; RV32-THEAD-NEXT:    th.mvnez a4, a6, a0
; RV32-THEAD-NEXT:    th.mvnez a5, a7, a0
; RV32-THEAD-NEXT:    mv a0, a4
; RV32-THEAD-NEXT:    mv a1, a5
; RV32-THEAD-NEXT:    ret
;
; RV32-XQCICM-LABEL: select_i64_sle:
; RV32-XQCICM:       # %bb.0:
; RV32-XQCICM-NEXT:    sltu a0, a2, a0
; RV32-XQCICM-NEXT:    slt a2, a3, a1
; RV32-XQCICM-NEXT:    qc.mveq a2, a1, a3, a0
; RV32-XQCICM-NEXT:    qc.mveqi a6, a2, 0, a4
; RV32-XQCICM-NEXT:    qc.mveqi a7, a2, 0, a5
; RV32-XQCICM-NEXT:    mv a0, a6
; RV32-XQCICM-NEXT:    mv a1, a7
; RV32-XQCICM-NEXT:    ret
;
; RV32-XQCICS-LABEL: select_i64_sle:
; RV32-XQCICS:       # %bb.0:
; RV32-XQCICS-NEXT:    slt t0, a3, a1
; RV32-XQCICS-NEXT:    sltu a0, a2, a0
; RV32-XQCICS-NEXT:    xor a1, a1, a3
; RV32-XQCICS-NEXT:    seqz a1, a1
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a0, t0
; RV32-XQCICS-NEXT:    mv a0, a1
; RV32-XQCICS-NEXT:    qc.selectnei a0, 0, a6, a4
; RV32-XQCICS-NEXT:    qc.selectnei a1, 0, a7, a5
; RV32-XQCICS-NEXT:    ret
;
; RV64-LABEL: select_i64_sle:
; RV64:       # %bb.0:
; RV64-NEXT:    bge a1, a0, .LBB23_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a2, a3
; RV64-NEXT:  .LBB23_2:
; RV64-NEXT:    mv a0, a2
; RV64-NEXT:    ret
;
; RV64-MIPS-LABEL: select_i64_sle:
; RV64-MIPS:       # %bb.0:
; RV64-MIPS-NEXT:    slt a0, a1, a0
; RV64-MIPS-NEXT:    mips.ccmov a0, a0, a3, a2
; RV64-MIPS-NEXT:    ret
  %cond = icmp sle i64 %a, %b
  %res = select i1 %cond, i64 %x, i64 %y
  ret i64 %res
}

