test_that("as.xhaz puts 'xhaz' first and preserves other classes", {
  x <- structure(list(), class = c("mexhaz", "xhaz", "mexhazLT", "foo"))
  y <- as.xhaz(x)

  testthat::expect_true(inherits(y, "xhaz"))
  testthat::expect_identical(class(y)[1], "xhaz")
  # Order of the remaining classes preserved after 'xhaz' is moved first
  expect_identical(class(y)[-1], c("mexhaz", "mexhazLT", "foo"))
})
