% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgb.plot.tree.R
\name{xgb.plot.tree}
\alias{xgb.plot.tree}
\title{Plot boosted trees}
\usage{
xgb.plot.tree(
  model,
  tree_idx = 1,
  plot_width = NULL,
  plot_height = NULL,
  with_stats = FALSE,
  ...
)
}
\arguments{
\item{model}{Object of class \code{xgb.Booster}. If it contains feature names
(they can be set through \code{\link[=setinfo]{setinfo()}}, they will be used in the
output from this function.}

\item{tree_idx}{An integer of the tree index that should be used. This
is an 1-based index.}

\item{plot_width, plot_height}{Width and height of the graph in pixels.
The values are passed to \code{DiagrammeR::render_graph()}.}

\item{with_stats}{Whether to dump some additional statistics about the
splits.  When this option is on, the model dump contains two additional
values: gain is the approximate loss function gain we get in each split;
cover is the sum of second order gradient in each node.}

\item{...}{Not used.

Some arguments that were part of this function in previous XGBoost versions are currently
deprecated or have been renamed. If a deprecated or renamed argument is passed, will throw
a warning (by default) and use its current equivalent instead. This warning will become an
error if using the \link[=xgboost-options]{'strict mode' option}.

If some additional argument is passed that is neither a current function argument nor
a deprecated or renamed argument, a warning or error will be thrown depending on the
'strict mode' option.

\bold{Important:} \code{...} will be removed in a future version, and all the current
deprecation warnings will become errors. Please use only arguments that form part of
the function signature.}
}
\value{
Rendered graph object which is an htmlwidget of ' class \code{grViz}. Similar to
"ggplot" objects, it needs to be printed when not running from the command
line.
}
\description{
Read a tree model text dump and plot the model.
}
\details{
The content of each node is visualized as follows:
\itemize{
\item For non-terminal nodes, it will display the split condition (number or name
if available, and the condition that would decide to which node to go
next).
\item Those nodes will be connected to their children by arrows that indicate
whether the branch corresponds to the condition being met or not being met.
\item Terminal (leaf) nodes contain the margin to add when ending there.
}

The "Yes" branches are marked by the "< split_value" label.
The branches also used for missing values are marked as bold
(as in "carrying extra capacity").

This function uses \href{https://www.graphviz.org/}{GraphViz} as DiagrammeR
backend.
}
\examples{
data("ToothGrowth")
x <- ToothGrowth[, c("len", "dose")]
y <- ToothGrowth$supp
model <- xgboost(
  x, y,
  nthreads = 1L,
  nrounds = 3L,
  max_depth = 3L
)

# plot the first tree
xgb.plot.tree(model, tree_idx = 1)

# Below is an example of how to save this plot to a file.
if (require("DiagrammeR") && require("htmlwidgets")) {
  fname <- file.path(tempdir(), "plot.html'")
  gr <- xgb.plot.tree(model, tree_idx = 1)
  htmlwidgets::saveWidget(gr, fname)
}
}
