% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGene.R
\name{SelectPropFitM}
\alias{SelectPropFitM}
\title{Selection proportional to fitness (vector/matrix).}
\usage{
SelectPropFitM(fit, lF, size = 1)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}

\item{size}{Number of selected genes. Default: 1.}
}
\value{
The index vector of the selected genes.
}
\description{
\code{SelectPropFitM()} implements selection
             proportional to fitness. Negative fitness
             vectors are shifted to \eqn{R^+}.
             The default of the function \code{lF$Offset()} is \code{1}. 
             Holland's schema theorem uses this selection function.
             See John Holland (1975) for further information.
}
\section{Warning}{

             The code is completely written in vector/matrix 
             operations. 
             \code{outer} uses \eqn{O(n^2)} memory cells.
}

\examples{
fit<-sample(10, 15, replace=TRUE)
SelectPropFitM(fit, NewlFselectGenes()) 
SelectPropFitM(fit, NewlFselectGenes(), length(fit)) 
}
\references{
Holland, John (1975): 
             \emph{Adaptation in Natural and Artificial Systems},  
             The University of Michigan Press, Ann Arbor.
             (ISBN:0-472-08460-7)
}
\seealso{
Other Selection Functions: 
\code{\link{SelectDuel}()},
\code{\link{SelectLRSelective}()},
\code{\link{SelectLinearRankTSR}()},
\code{\link{SelectPropFit}()},
\code{\link{SelectPropFitDiff}()},
\code{\link{SelectPropFitDiffM}()},
\code{\link{SelectPropFitDiffOnln}()},
\code{\link{SelectPropFitOnln}()},
\code{\link{SelectSTournament}()},
\code{\link{SelectSUS}()},
\code{\link{SelectTopK}()},
\code{\link{SelectTournament}()},
\code{\link{SelectUniform}()},
\code{\link{SelectUniformP}()}
}
\concept{Selection Functions}
