% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaOperatorPipelinesInGene.R
\name{newCrossMut2PipelineG}
\alias{newCrossMut2PipelineG}
\title{Converts two genes into a pipeline embedded in a gene with crossover and mutation for both kids.}
\usage{
newCrossMut2PipelineG(g, g1)
}
\arguments{
\item{g}{A gene.}

\item{g1}{A gene.}
}
\value{
A gene with embedded genetic operator pipeline 
        with crossover with two kids and mutation on both kids.
        The argument \code{lF} of the function \code{$Pipeline()} 
        configures the behavior of the pipeline.
}
\description{
The embedded pipeline is \code{evaluate(accept((crossover o mutation), gene, gene1))}.
             Mutation is applied to both kids.
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCross2Gene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.5}
lFxegaGaGene$BitMutationRate1<-function(fit, lF) {0.2}
lFxegaGaGene$CrossRate<-function(fit, lF) {0.5}
lFxegaGaGene$Accept<-function(OpPipeline, gene, lF) {OpPipeline(gene, lF)}
g<-xegaGaInitGene(lFxegaGaGene)
g1<-xegaGaInitGene(lFxegaGaGene)
a<-newCrossMut2PipelineG(g, g1)
print(a)
a$Pipeline(a, lFxegaGaGene)
}
\seealso{
Other Genetic Operator Pipelines in Gene: 
\code{\link{newCross2Mut1PipelineG}()},
\code{\link{newCross2Mut2PipelineG}()},
\code{\link{newCross2PipelineG}()},
\code{\link{newCrossMutPipelineG}()},
\code{\link{newCrossPipelineG}()},
\code{\link{newMutPipelineG}()},
\code{\link{newPipelineG}()}
}
\concept{Genetic Operator Pipelines in Gene}
