% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MC_run_mc_mediation.R
\name{run_mc_mediation}
\alias{run_mc_mediation}
\title{Run Monte Carlo-Based Mediation Inference}
\usage{
run_mc_mediation(
  fit,
  data,
  standardized = FALSE,
  R = 20000,
  seed = 123,
  alpha = 0.05,
  alphastd = 0.05
)
}
\arguments{
\item{fit}{A fitted \code{lavaan} model.}

\item{data}{The dataset used for the fitted model.}

\item{standardized}{Logical. If TRUE, standardized results will also be returned. Default is FALSE.}

\item{R}{Integer. Number of Monte Carlo replications. Default is 20000.}

\item{seed}{Integer. Random seed for reproducibility. Default is 123.}

\item{alpha}{Numeric value for the confidence level of unstandardized Monte Carlo intervals. Default is 0.05.}

\item{alphastd}{Numeric value for the confidence level of standardized Monte Carlo intervals. Default is 0.05.}
}
\value{
A list with unstandardized and (if requested) standardized results.
Each result includes Monte Carlo estimates, SEs, and CIs.
}
\description{
Performs Monte Carlo simulation to estimate confidence intervals for both
unstandardized and (optionally) standardized mediation parameters, based on fitted SEM models.
}
\keyword{internal}
