% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_basic_contrasts.R
\name{mc_summary_pct}
\alias{mc_summary_pct}
\title{Compute Monte Carlo Estimates, Standard Errors, and CIs (with Percent Labels)}
\usage{
mc_summary_pct(x, label, ci_level = 0.95, digits = 3)
}
\arguments{
\item{x}{Numeric vector of Monte Carlo samples.}

\item{label}{Character string for the value in the \code{Path} column of the output.}

\item{ci_level}{Confidence level for the CI (default \code{0.95}).}

\item{digits}{Number of decimal places to retain (default \code{3}).}
}
\value{
A \code{data.frame} containing the path label, estimate, standard error, and CI.
Column names are formatted like \code{"2.5\%CI.Lo"} and \code{"97.5\%CI.Up"}.
}
\description{
\code{mc_summary_pct()} summarizes a numeric vector of Monte Carlo samples \code{x} by
computing its mean, standard deviation, and percentile-based confidence interval.
The result is returned as a \code{data.frame} with column names that include percentage
signs. This function is typically used to generate tables of mediation effects or
path coefficient estimates with path labels.

Returned columns include:
\itemize{
\item \code{Path}: Path label.
\item \code{Estimate}: Sample mean.
\item \code{SE}: Sample standard deviation.
\item \verb{<p\%CI.Lo>}, \verb{<p\%CI.Up>}: Lower and upper bounds of the percentile CI,
with \verb{\%} in the column names.
}
}
\keyword{internal}
