% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenerateModelCN.R
\name{GenerateModelCN}
\alias{GenerateModelCN}
\title{Generate Chained Mediation Model}
\usage{
GenerateModelCN(prepared_data, MP = character(0))
}
\arguments{
\item{prepared_data}{A data frame returned by \code{\link[=PrepareData]{PrepareData()}}, containing the processed
within-subject mediator and outcome variables. The data frame must include columns for
difference scores (\code{Mdiff}) and average scores (\code{Mavg}) of mediators, as well as the
outcome difference score (\code{Ydiff}).}

\item{MP}{A character vector specifying which paths are moderated by variable(s) W.
Valid entries include:
- \code{"a2"}, \code{"a3"}, ...: moderation on the a paths (W → Mdiff), for mediators beyond M1.
- \code{"b2"}, \code{"b3"}, ...: moderation on the b paths (Mdiff × W → Ydiff).
- \code{"b_1_2"}, \code{"b_2_3"}, ...: moderation on cross-paths from one mediator to the next (e.g., M1 → M2).
- \code{"d2"}, \code{"d3"}, ...: moderation on the d paths (Mavg × W → Ydiff).
- \code{"d_1_2"}, \code{"d_2_3"}, ...: moderation on cross-paths from one Mavg to the next Mdiff.
- \code{"cp"}: moderation on the direct effect from X to Y (i.e., W → Ydiff).

\if{html}{\out{<div class="sourceCode">}}\preformatted{      The function detects and inserts the correct interaction terms (e.g., \code{int_M2diff_W1}) based on these labels.
}\if{html}{\out{</div>}}}
}
\value{
A character string representing the SEM model syntax for the specified chained mediation analysis.
}
\description{
Dynamically generates a structural equation modeling (SEM) syntax for
chained mediation analysis based on the prepared dataset. The function computes regression
equations for mediators and the outcome variable, indirect effects along multi-step mediation paths,
total effects, contrasts between indirect effects, and coefficients in different conditions.
}
\details{
This function is used to construct SEM models for chained mediation analysis.
It automatically parses variable names from the prepared dataset and dynamically creates
the necessary model syntax, including:
\itemize{
\item \strong{Outcome regression}: Defines the relationship between the difference scores of
the outcome (\code{Ydiff}) and the mediators (\code{Mdiff}) as well as their average scores (\code{Mavg}).
\item \strong{Mediator regressions}: Defines the sequential regression models for each mediator's
difference score, incorporating prior mediators as predictors.
\item \strong{Indirect effects}: Computes the indirect effects along all possible multi-step
mediation paths using the product of path coefficients.
\item \strong{Total indirect effect}: Calculates the sum of all indirect effects from the chained
mediation paths.
\item \strong{Total effect}: Combines the direct effect (\code{cp}) and the total indirect effect.
\item \strong{Contrasts of indirect effects}: Optionally calculates the pairwise contrasts between
the indirect effects for different mediation paths.
\item \strong{Coefficients in different 'X' conditions}: Calculates path coefficients in different \code{X}
conditions to observe the moderation effect of \code{X}.
}

This model is suitable for chained mediation designs where mediators influence each other in
a sequential manner, forming multi-step mediation paths.
}
\examples{
# Example prepared data
prepared_data <- data.frame(
  M1diff = rnorm(100),
  M2diff = rnorm(100),
  M3diff = rnorm(100),
  M1avg = rnorm(100),
  M2avg = rnorm(100),
  M3avg = rnorm(100),
  Ydiff = rnorm(100)
)

# Generate SEM model syntax
sem_model <- GenerateModelCN(prepared_data)
cat(sem_model)

}
\seealso{
\code{\link[=PrepareData]{PrepareData()}}, \code{\link[=wsMed]{wsMed()}}, \code{\link[=GenerateModelP]{GenerateModelP()}}
}
