#' @title Example Data for within subject mediation
#' @keywords internal
#' @description A simulated dataset containing variables for within-subject mediation analysis.
#' The dataset includes four within-subject variables (A, B, C, D), each measured at three levels:
#' - **A1, A2, A3**: Levels of within-subject variable A (e.g., mediator conditions).
#' - **B1, B2, B3**: Levels of within-subject variable B (e.g., outcome conditions).
#' - **C1, C2, C3**: Levels of within-subject variable.
#' - **D1, D2, D3**: Levels of within-subject variable.
#'
#' @format A tibble (data frame) with 100 rows and 12 variables:
#' \describe{
#'   \item{A1}{Numeric variable}
#'   \item{A2}{Numeric variable}
#'   \item{A3}{Numeric variable}
#'   \item{B1}{Numeric variable}
#'   \item{B2}{Numeric variable}
#'   \item{B3}{Numeric variable}
#'   \item{C1}{Numeric variable}
#'   \item{C2}{Numeric variable}
#'   \item{C3}{Numeric variable}
#'   \item{D1}{Numeric variable}
#'   \item{D2}{Numeric variable}
#'   \item{D3}{Numeric variable}
#' }
#'
#'
#' @examples
#' data(example_data)
#' head(example_data)
"example_data"

