% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{getMeta}
\alias{getMeta}
\alias{getMetaLive}
\alias{importNOAA}
\alias{importNOAAlite}
\title{Deprecated ISD access functions}
\usage{
getMeta(
  site = NULL,
  lat = NULL,
  lon = NULL,
  crs = 4326,
  country = NULL,
  state = NULL,
  n = 10,
  end.year = "current",
  provider = c("OpenStreetMap", "Esri.WorldImagery"),
  plot = TRUE,
  returnMap = FALSE
)

getMetaLive(...)

importNOAA(
  code = "037720-99999",
  year = 2014,
  hourly = TRUE,
  source = c("delim", "fwf"),
  quiet = FALSE,
  path = NA,
  n.cores = NULL
)

importNOAAlite(code = "037720-99999", year = 2025, quiet = FALSE, path = NA)
}
\arguments{
\item{site}{A site name search string e.g. \code{site = "heathrow"}. The search
strings and be partial and can be upper or lower case e.g. \code{site = "HEATHR"}.}

\item{lat, lon}{Decimal latitude and longitude (or other Y/X coordinate if
using a different \code{crs}). If provided, the \code{n_max} closest ISD stations to this
coordinate will be returned.}

\item{crs}{The coordinate reference system (CRS) of the data, passed to
\code{\link[sf:st_crs]{sf::st_crs()}}. By default this is \href{https://epsg.io/4326}{EPSG:4326}, the
CRS associated with the commonly used latitude and longitude coordinates.
Different coordinate systems can be specified using \code{crs} (e.g., \code{crs = 27700} for the \href{https://epsg.io/27700}{British National Grid}). Note that
non-lat/lng coordinate systems will be re-projected to EPSG:4326 for making
comparisons with the NOAA metadata plotting on the map.}

\item{country}{The country code. This is a two letter code. For a full
listing see \url{https://www.ncei.noaa.gov/pub/data/noaa/isd-history.csv}.}

\item{state}{The state code. This is a two letter code.}

\item{n}{The number of nearest sites to search based on \code{latitude} and
\code{longitude}.}

\item{end.year}{To help filter sites based on how recent the available data
are. \code{end.year} can be "current", "any" or a numeric year such as 2016, or
a range of years e.g. 1990:2016 (which would select any site that had an
end date in that range. \strong{By default only sites that have some data for the
current year are returned}.}

\item{provider}{By default a map will be created in which readers may toggle
between a vector base map and a satellite/aerial image. \code{provider} allows
users to override this default; see
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list
of all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface.}

\item{plot}{If \code{TRUE} will plot sites on an interactive leaflet map.}

\item{returnMap}{Should the leaflet map be returned instead of the meta data?
Default is \code{FALSE}.}

\item{...}{Currently unused.}

\item{code}{The identifying code as a character string. The code is a
combination of the USAF and the WBAN unique identifiers. The codes are
separated by a \dQuote{-} e.g. \code{code = "037720-99999"}.}

\item{year}{The year to import. This can be a vector of years e.g. \code{year = 2000:2005}.}

\item{hourly}{Should hourly means be calculated? The default is \code{TRUE}. If
\code{FALSE} then the raw data are returned.}

\item{source}{The NOAA ISD service stores files in two formats; as delimited
CSV files (\code{"delim"}) and as fixed width files (\code{"fwf"}).
\code{\link[=import_isd_hourly]{import_isd_hourly()}} defaults to \code{"delim"} but, if the delimited data
store is down, users may wish to try \code{"fwf"} instead. Both data sources
should be identical to one another.}

\item{quiet}{Print missing sites/years to the screen? Defaults to \code{FALSE}.}

\item{path}{If a file path is provided, the data are saved as an rds file at
the chosen location e.g.  \code{path = "C:/Users/David"}. Files are saved by
year and site.}

\item{n.cores}{No longer recommended; please set \code{\link[mirai:daemons]{mirai::daemons()}} in your R
session. This argument is provided for back compatibility, and is passed to
the \code{n} argument of \code{\link[mirai:daemons]{mirai::daemons()}} on behalf of the user. Any set
daemons will be reset once the function completes. Default is \code{NULL}, which
means no parallelism. \code{n.cores = 1L} is equivalent to \code{n.cores = NULL}.}
}
\value{
A data frame is returned with all available meta data, mostly
importantly including a \code{code} that can be supplied to \code{\link[=importNOAA]{importNOAA()}}. If
latitude and longitude searches are made an approximate distance, \code{dist} in
km is also returned.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is part of an old \code{worldmet} API. Please use the following
alternatives:
\itemize{
\item \code{\link[=getMeta]{getMeta()}} -> \code{\link[=import_isd_stations]{import_isd_stations()}}
\item \code{\link[=getMetaLive]{getMetaLive()}} -> \code{\link[=import_isd_stations_live]{import_isd_stations_live()}}
\item \code{\link[=importNOAA]{importNOAA()}} -> \code{\link[=import_isd_hourly]{import_isd_hourly()}}
\item \code{\link[=importNOAAlite]{importNOAAlite()}} -> \code{\link[=import_isd_lite]{import_isd_lite()}}
\item the \code{path} argument -> \code{\link[=write_met]{write_met()}}
}
}
