% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.doc2vec.R
\name{as.textmodel_doc2vec}
\alias{as.textmodel_doc2vec}
\title{Create distributed representation of documents}
\usage{
as.textmodel_doc2vec(
  x,
  model,
  normalize = FALSE,
  weights = 1,
  pattern = NULL,
  group_data = FALSE,
  ...
)
}
\arguments{
\item{x}{a \link[quanteda:tokens]{quanteda::tokens} or \link[quanteda:dfm]{quanteda::dfm} object.}

\item{model}{a textmodel_wordvector object.}

\item{normalize}{if \code{TRUE}, normalized word vectors before creating document vectors.}

\item{weights}{weight the word vectors by user-provided values; either a single value or
multiple values sorted in the same order as the word vectors.}

\item{pattern}{\link[quanteda:pattern]{quanteda::pattern} to select words to apply \code{weights}.}

\item{group_data}{if \code{TRUE}, apply \code{dfm_group(x)} before creating document vectors.}

\item{...}{additional arguments passed to \link[quanteda:object2id]{quanteda::object2id}.}
}
\value{
Returns a textmodel_docvector object with the following elements:
\item{values}{a list of matrices for word and document vectors.}
\item{dim}{the size of the document vectors.}
\item{concatenator}{the concatenator in \code{x}.}
\item{docvars}{document variables copied from \code{x}.}
\item{normalize}{if the document vectors are normalized.}
\item{call}{the command used to execute the function.}
\item{version}{the version of the wordvector package.}
}
\description{
Create distributed representation of documents as weighted word vectors.
}
