% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.wmw_test.R
\name{plot.wmw_test}
\alias{plot.wmw_test}
\title{Plot Method for wmw_test Objects}
\usage{
\method{plot}{wmw_test}(x, combine_plots = TRUE, ...)
}
\arguments{
\item{x}{Object of class 'wmw_test' returned by \code{wmw_test()}}

\item{combine_plots}{Logical, whether to return combined plot using patchwork
(TRUE) or list of individual plots (FALSE). Only relevant when special_case = TRUE}

\item{...}{Additional arguments (not currently used)}
}
\value{
No return value, called for side effects. Creates a plot visualizing
the Wilcoxon-Mann-Whitney test results including distributions,
test statistic, and confidence information.
}
\description{
Creates empirical ROC curve plot with test results (p-value, eAUC with confidence
interval) displayed in subtitle. If \code{ci_method = 'boot'} was used in \code{wmw_test()},
the plot includes confidence bands for the ROC curve constructed using the same
bootstrap resamples used for the AUC confidence interval.
}
\details{
When \code{special_case = TRUE} was used in \code{wmw_test()}, an additional boxplot with
swarmplot overlay is created, showing the eAUC as effect size estimate with
confidence interval in the subtitle (demonstrating the dual interpretation of
eAUC in the location-shift case).
}
