% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tax.r
\name{tax}
\alias{tax}
\title{Search taxonomic reference lists including concept synonomy and taxonomic hierarchy.}
\usage{
tax(x, refl = tax.refl(), syn = TRUE, concept = NULL, strict = FALSE, idtype)
}
\arguments{
\item{x}{Species number, lettercode or species name(s)}

\item{refl}{Taxonomic reference list}

\item{syn}{Return also synonym names}

\item{concept}{Name of the file with an alternative taxon view stored in the reference list directory, see details.}

\item{strict}{Exact match or partial matching with \code{\link{grep}}}

\item{idtype}{is x of type 'is_id', 'is_shortletter', or 'is_scientific'}
}
\description{
Input is either species number (integer), shortletter (7 characters) or full (exact!) species name.
}
\details{
\dfn{concept}: GermanSL is a list with a single taxon view according to the standard lists of the different taxon groups (e.g Wisskirchen and Haeupler for higher plants, see).
  Nevertheless a huge number of synonyms is included which allows in many cases the transformation into different concepts.
  For illustration the concept of \emph{Armeria maritima} from Korneck 1996 is included, which accepts e.g. \emph{Armeria maritima ssp. bottendorfensis}.
  \dfn{parse.taxa}: parse genus and epitheta from name strings.
  \dfn{taxname.removeAuthors} Remove name authors from full scientific name strings.
}
\references{
Jansen, F. and Dengler, J. (2008) GermanSL - eine universelle taxonomische Referenzliste für Vegetationsdatenbanken. Tuexenia, 28, 239-253.
}
\author{
Florian Jansen \email{florian.jansen@uni-rostock.de}
}
