% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vegclust2kmeans.R
\name{vegclust2kmeans}
\alias{vegclust2kmeans}
\title{Reshapes as kmeans object}
\usage{
vegclust2kmeans(x)
}
\arguments{
\item{x}{An object of class \code{\link{vegclust}} to be casted, where \code{method="KM"} and \code{mode="raw"}.}
}
\value{
An object of class \code{\link{kmeans}}
}
\description{
This function casts an object of class \code{\link{vegclust}} into an object of class \code{\link{kmeans}}.
}
\examples{
## Loads data  
data(wetland)

## This equals the chord transformation 
wetland.chord <- as.data.frame(sweep(as.matrix(wetland), 1, 
                                     sqrt(rowSums(as.matrix(wetland)^2)), "/"))

## Create noise clustering with 3 clusters. Perform 10 starts from random seeds 
wetland.vc <- vegclust(wetland.chord, mobileCenters=3, 
                       method="KM", nstart=10)

## Reshapes as kmeans object
wetland.km <- vegclust2kmeans(wetland.vc)
wetland.km
}
\seealso{
\code{\link{vegclust}}, \code{\link{kmeans}}
}
\author{
Miquel De \enc{Cáceres}{Caceres}, CREAF
}
