% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSpeciesTable.R
\name{getSpeciesTable}
\alias{getSpeciesTable}
\title{Get Table For Species}
\usage{
getSpeciesTable(
  token,
  interval = NULL,
  target_year,
  cumulative = FALSE,
  include_abundance = FALSE,
  species = NULL,
  trap = NULL,
  sex = "female",
  separate_by = NULL,
  output_format = "auto",
  caption = NULL,
  agency_id = NULL
)
}
\arguments{
\item{token}{Authentication token for API access, obtained from `getToken()`}

\item{interval}{Time interval for aggregation. One of: "CollectionDate", "Week", "Biweek", "Month", or NULL for year-level summary}

\item{target_year}{The focal year to highlight in the plot (integer)}

\item{cumulative}{T/F Adds columns for the cumulative sum count Default to FALSE}

\item{include_abundance}{T/F Adds column for abundance (non-cumulative only)}

\item{species}{Character vector for filtering species. View species in your data `unique(data$species_display_name)`. Defaults to all species if no selection}

\item{trap}{Character vector for filtering trap type by acronym. View trap types in your data`unique(data$trap_acronym`. Defaults to all trap types}

\item{sex}{Character vector for filtering sex type. View sex options `unique(data$sex_type`). Defaults to "female".}

\item{separate_by}{Adds a column from the data as a grouping variable.
Accepts 'site', 'city', 'county', 'agency', 'trap', 'spatial'}

\item{output_format}{Format to output table display. Accepts 'html', 'pdf',
'word' or 'auto'. Default auto returns the console format dataframe.}

\item{caption}{Caption for table}

\item{agency_id}{Agency identifier to filter data if applicable}
}
\value{
A table displaying invasive species interval or/and cumulative counts over time
}
\description{
Allows users to create a custom table for vector species. The invasive
species count, trap nights, and abundance are calculated by chosen groupings
or time intervals. The table has output options based on document format.
}
