% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_models.R
\name{fit_bayesian_hierarchical}
\alias{fit_bayesian_hierarchical}
\title{Fit Bayesian Hierarchical Panel Model}
\usage{
fit_bayesian_hierarchical(
  panel_data,
  include_time = TRUE,
  chains = 4L,
  iter = 4000L,
  seed = 12345L
)
}
\arguments{
\item{panel_data}{Data frame in panel format.}

\item{include_time}{Logical. Include time trend. Default TRUE.}

\item{chains}{Number of MCMC chains. Default 4.}

\item{iter}{Number of iterations. Default 4000.}

\item{seed}{Random seed. Default 12345.}
}
\value{
A list containing:
\describe{
  \item{model}{The fitted rstanarm model object}
  \item{r2_bayes}{Bayesian R-squared (mean)}
  \item{summary}{Model summary for fixed effects}
  \item{metrics}{In-sample evaluation metrics}
}
}
\description{
Fits a Bayesian mixed effects model with random slopes by sector.
}
\examples{
\dontrun{
if (requireNamespace("rstanarm", quietly = TRUE)) {
  set.seed(123)
  panel <- data.frame(
    year = rep(2000:2009, 5),
    sector = rep(LETTERS[1:5], each = 10),
    time = rep(1:10, 5),
    log_direct = rnorm(50, 5, 0.5),
    log_production = rnorm(50, 5, 0.5)
  )
  panel$log_production <- panel$log_direct * 0.95 + rnorm(50, 0, 0.1)

  result <- fit_bayesian_hierarchical(panel, chains = 2, iter = 1000)
  print(result$r2_bayes)
}
}

}
