% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{evaluate_insample}
\alias{evaluate_insample}
\title{Evaluate In-Sample Model Performance}
\usage{
evaluate_insample(predicted, actual)
}
\arguments{
\item{predicted}{Numeric vector of predicted values (log scale).}

\item{actual}{Numeric vector of actual values (log scale).}
}
\value{
A list containing:
\describe{
  \item{mae_log}{MAE in log scale}
  \item{rmse_log}{RMSE in log scale}
  \item{mae_orig}{MAE in original scale (after exp transformation)}
  \item{rmse_orig}{RMSE in original scale}
  \item{mae_rel_range}{MAE as percentage of range}
}
}
\description{
Computes various error metrics comparing predictions to actual values.
}
\examples{
set.seed(123)
actual <- log(runif(50, 100, 200))
predicted <- actual + rnorm(50, 0, 0.1)
evaluate_insample(predicted, actual)

}
