% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_comparison.R
\name{compare_models}
\alias{compare_models}
\title{Compare All Models}
\usage{
compare_models(
  twoway_result = NULL,
  mundlak_result = NULL,
  bayes_result = NULL,
  pls_result = NULL
)
}
\arguments{
\item{twoway_result}{Result from fit_twoway_fe (or NULL).}

\item{mundlak_result}{Result from fit_mundlak_cre (or NULL).}

\item{bayes_result}{Result from fit_bayesian_hierarchical (or NULL).}

\item{pls_result}{Result from fit_pls_multivariate (or NULL).}
}
\value{
A data frame with model comparison metrics.
}
\description{
Generates a comprehensive comparison table of all fitted models.
}
\examples{
\donttest{
if (requireNamespace("plm", quietly = TRUE)) {
  set.seed(123)
  panel <- data.frame(
    year = rep(2000:2019, 5),
    sector = rep(LETTERS[1:5], each = 20),
    log_direct = rnorm(100, 5, 0.5),
    log_production = rnorm(100, 5, 0.5)
  )
  panel$log_production <- panel$log_direct * 0.95 + rnorm(100, 0, 0.1)

  twoway <- fit_twoway_fe(panel)
  mundlak <- fit_mundlak_cre(panel)

  comparison <- compare_models(
    twoway_result = twoway,
    mundlak_result = mundlak
  )
  print(comparison)
}
}

}
