% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ma.R
\name{calc_ma}
\alias{calc_ma}
\title{Calculate mass accuracy}
\usage{
calc_ma(m, m_cal, ...)
}
\arguments{
\item{m}{Measured mass}

\item{m_cal}{Calculated (theoretical) mass.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A numeric vector of mass accuracy.
}
\description{
Calculates relative mass accuracy (ma, in parts per million) as:
(measured mass - theoretical mass) / theoretical mass * 1000000
Returned value is rounded to 4 digits.
}
\examples{
# Use of single values
calc_ma(m = 264.08641, m_cal = 264.08653)
# Use in a molecular formula table
calc_ma(m = mf_data_demo$m, m_cal = mf_data_demo$m_cal)
mf_data_demo[, .(m, m_cal, accuracy_in_ppm = calc_ma(m, m_cal))]
}
\seealso{
Other calculations: 
\code{\link{calc_data_summary}()},
\code{\link{calc_dbe}()},
\code{\link{calc_eval_params}()},
\code{\link{calc_exact_mass}()},
\code{\link{calc_ideg}()},
\code{\link{calc_neutral_mass}()},
\code{\link{calc_nm}()},
\code{\link{calc_norm_int}()},
\code{\link{calc_number_assignment}()},
\code{\link{calc_number_occurrence}()},
\code{\link{calc_recalibrate_ms}()}
}
\concept{calculations}
\keyword{misc}
