% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_indeces.R
\name{calc_iterr}
\alias{calc_iterr}
\title{Calculate terrestrial indeces Iterr and Iterr2 (after Medeiros et al. 2016)}
\usage{
calc_iterr(
  mfd,
  mf_col = "mf",
  magnitude_col = "i_magnitude",
  grp = "file_id",
  ...
)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{mf_col}{Name of the column containing molecular formulas (string)}

\item{magnitude_col}{Name of the column containing absolute or
relative mass peak magnitudes (string).}

\item{grp}{Character vector. Names of columns (e.g., sample or file identifiers)
used to aggregate results.}

\item{...}{Additional arguments passed to methods.}
}
\value{
Iterr and iterr2 values
}
\description{
Calculate a degradation index 'Iterr' and modified index 'iterr2' after Medeiros et al. (2016).
High Iterr values represent higher contribution of terrestrial material (i.e. higher contribution
of peaks that correlate positively with delta13C) while low values represent less terrestrial
material (i.e. higher contribution of peaks that correlate negatively with delta13C).
Iterr / Iterr2 are calculated from a peak magnitude ratio of 50 or 5 POS and NEG formulas, respectively:
sum(POS) / (sum(POS) + sum(NEG))
Therefore Iterr / Iterr2 range between 1 and 0. It should be noted that absolute values strongly depend
on factors such as type of solid phase extraction, ionization method, instrument settings etc.
Therefore values can only be interpreted as relative changes.
It should also be noted that for an appropriate evaluation ALL index formulas must be present.
}
\examples{
library(data.table)

# Create a minimal dataset containing all required
# POS, NEG, POS2, and NEG2 formulas for demonstration

demo_iterr <- data.table(
  file_id = 1,
  mf = c(
    # NEG (Iterr)
    'C13H12O5','C15H14O4','C14H12O5','C14H14O5','C13H12O6',
    'C16H16O4','C15H14O5','C14H12O6','C15H16O5','C14H14O6',
    'C16H14O5','C16H16O5','C15H14O6','C15H16O6','C14H14O7',
    'C17H16O5','C16H14O6','C17H18O5','C16H16O6','C15H14O7',
    'C17H16O6','C16H14O7','C18H18O6','C17H16O7','C17H18O7',
    'C18H16O7','C18H18O7','C17H16O8','C19H18O7','C20H20O7',
    'C19H18O8','C20H18O9','C19H16O10','C21H20O9','C20H18O10',
    'C22H22O9','C21H20O10','C23H22O10','C24H24O10','C25H26O10',

    # POS (Iterr)
    'C15H19NO6','C15H21NO6','C17H21NO7','C17H23NO7','C17H22O8',
    'C16H21NO8','C17H20N2O7','C17H19NO8','C18H23NO7','C17H21NO8',
    'C18H24O8','C16H19NO9','C17H23NO8','C17H22O9','C17H24O9',
    'C18H21NO8','C17H19NO9','C18H23NO8','C18H22O9','C17H21NO9',
    'C18H24O9','C18H20N2O8','C18H21NO9','C19H24O9','C18H23NO9',
    'C18H22O10','C18H24O10','C20H24O9','C19H22O10','C20H26O9',
    'C19H24O10','C19H26O10','C20H24O10','C20H26O10','C19H24O11',
    'C20H24O11','C20H26O11','C20H26O12','C22H28O11','C21H28O12',

    # NEG2 (Iterr2)
    'C17H18O7','C18H18O7','C17H16O7','C17H16O8','C15H16O6',

    # POS2 (Iterr2)
    'C20H24O9','C20H24O10','C19H22O10','C17H21NO8','C20H26O9'
  ),

  # Assign magnitude values (arbitrary but valid)
  i_magnitude = c(
    rep(1000, 40),  # NEG
    rep(2000, 40),  # POS
    rep(1500, 5),   # NEG2
    rep(1800, 5)    # POS2
  )
)

calc_iterr(
  mfd = demo_iterr,
  mf_col = "mf",
  magnitude_col = "i_magnitude",
  grp = "file_id"
)
}
\concept{index calculations}
\keyword{misc}
