% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/typeR.R
\name{typeR}
\alias{typeR}
\title{Simulate Typing of an R Script File}
\usage{
typeR(file, delay = 0.05)
}
\arguments{
\item{file}{Path to the R script file to simulate typing.}

\item{delay}{The delay (in seconds) between typing each character (default: 0.05).}
}
\value{
Invisibly returns NULL. Called for the side effect of displaying
typed content in the console with animation.
}
\description{
Simulates typing out the content of an R script file, line by line,
character by character, to create an animation effect for live coding
presentations or educational demonstrations.
}
\examples{
# Create a temporary R script for demonstration
tmp <- tempfile(fileext = ".R")
writeLines(c(
  "# Example R script",
  "x <- 1:10",
  "mean(x)"
), tmp)

# Simulate typing the script (fast for testing)
typeR(tmp, delay = 0.01)

# Clean up
unlink(tmp)

# Longer example with realistic typing speed
\donttest{
  tmp2 <- tempfile(fileext = ".R")
  writeLines(c(
    "# Data analysis example",
    "data <- mtcars",
    "model <- lm(mpg ~ wt, data = data)",
    "summary(model)"
  ), tmp2)
  typeR(tmp2, delay = 0.08)
  unlink(tmp2)
}
}
