% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tspredbench.R
\docType{data}
\name{NN5}
\alias{NN5}
\title{NN5 Time Series Competition}
\format{
A data frame with 735 rows and 111 columns. Each column corresponds to a different univariate daily time series.
}
\source{
\href{http://www.neural-forecasting-competition.com/NN5/index.htm}{NN5 Time Series Forecasting Competition}
}
\usage{
data(NN5)
}
\description{
Daily time series from the NN5 forecasting competition.
Data Type: ATM withdrawal amounts. Category: Benchmark. Observations: 735 per series, 111 series.
The dataset contains 111 univariate time series representing daily cash withdrawals from ATMs in England.
Each series includes 735 observations and may contain missing values and multiple seasonal patterns.
Participants were asked to forecast the next 56 values for each series, and performance was evaluated using the mean sMAPE across all series.
}
\details{
NN5 consists of daily ATM withdrawal amounts with complex multiple seasonalities and occasional
missing values. Forecasts are evaluated via sMAPE on a 56-day horizon.
}
\examples{
# Load NN5 dataset
data(NN5)
# NN5 <- loadfulldata(NN5)

# Select one series and plot
series <- NN5[["NN5.111"]]
ts.plot(series, ylab = "Withdrawals", xlab = "Day", main = "NN5 example series")
}
\references{
Crone, S.F. (2008). \emph{Results of the NN5 Time Series Forecasting Competition}. IEEE WCCI 2008, Hong Kong.
NN5 Competition (2008). \url{http://www.neural-forecasting-competition.com/NN5/index.htm}
}
\keyword{benchmark}
\keyword{datasets}
