% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_management.R
\name{add_vision_model}
\alias{add_vision_model}
\title{User-Friendly Vision Model Management Functions}
\usage{
add_vision_model(
  name,
  model_id,
  description = NULL,
  architecture = "clip",
  test_labels = NULL,
  force = FALSE
)
}
\arguments{
\item{name}{A short, memorable name for your model (e.g., "my-emotion-model")}

\item{model_id}{HuggingFace model identifier or path to local model directory}

\item{description}{Optional description of the model and its purpose}

\item{architecture}{Model architecture type. Currently supported:
\itemize{
  \item \code{"clip"}: Standard CLIP models (most compatible)
  \item \code{"clip-custom"}: CLIP variants needing special handling
  \item \code{"blip"}: BLIP models (caption-likelihood scoring)
  \item \code{"align"}: ALIGN dual-encoder models (direct similarity)
}}

\item{test_labels}{Optional character vector to test the model immediately}

\item{force}{Logical indicating whether to overwrite existing model with same name}
}
\value{
Invisibly returns TRUE if successful
}
\description{
High-level functions for managing vision models in transforEmotion,
providing an easy interface for extending the package with custom models.

User-friendly wrapper for registering custom vision models with automatic
validation and helpful error messages.
}
\examples{
\dontrun{
# Add a fine-tuned CLIP model for emotion recognition
add_vision_model(
  name = "emotion-clip",
  model_id = "openai/clip-vit-large-patch14",
  description = "Large CLIP model for better emotion recognition",
  test_labels = c("happy", "sad", "angry"),
  force = TRUE
)

# Add a local model
add_vision_model(
  name = "my-local-model",
  model_id = "/path/to/my/model",
  description = "My custom fine-tuned model"
)

# Add experimental BLIP model
add_vision_model(
  name = "blip-base",
  model_id = "Salesforce/blip-image-captioning-base",
  architecture = "blip",
  description = "BLIP model for image captioning"
)

# Now use any of them in analysis
result <- image_scores("photo.jpg", c("happy", "sad"), model = "emotion-clip")
batch_results <- image_scores_dir("photos/", c("positive", "negative"), 
                                 model = "my-local-model")
}
}
\author{
Aleksandar Tomasevic <atomashevic@gmail.com>
Add a Custom Vision Model
}
